/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class ResetCounterFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_RESET_COUNTER = "Usage: ${reset_counter(level)}. Example: ${reset_counter(1)}";

    @Override
    public String getName() {
        return "reset_counter()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            try {
                ctx.resetCounter(this.parseInt(sources[0]));
            }
            catch (NumberFormatException nfe) {
                this.logException(nfe, "{}: NumberFormatException parsing counter level \"{}\" in element \"{}\". Parameters: {}", new Object[]{this.getName(), sources[0].toString(), caller, this.getParametersAsString(sources)});
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_RESET_COUNTER;
    }

    @Override
    public String shortDescription() {
        return "Resets the value of the counter with the given index";
    }
}

