/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class RoundFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_ROUND = "Usage: ${round(value1 [, decimalPlaces])}. Example: ${round(2.345678, 2)}";

    @Override
    public String getName() {
        return "round()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        String decimalPlaces = "0";
        if (sources == null) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        if (sources.length == 1) {
            if (sources[0] == null) {
                return null;
            }
            if (StringUtils.isBlank((CharSequence)sources[0].toString())) {
                return "";
            }
            double f1 = Double.parseDouble(sources[0].toString());
            return Math.round(f1);
        }
        if (sources.length == 2) {
            if (sources[1] == null) {
                this.logParameterError(caller, sources, ctx.isJavaScriptContext());
                return this.usage(ctx.isJavaScriptContext());
            }
            decimalPlaces = sources[1].toString();
            try {
                double f1 = Double.parseDouble(sources[0].toString());
                double f2 = Math.pow(10.0, Double.parseDouble(decimalPlaces));
                long r = Math.round(f1 * f2);
                return (double)r / f2;
            }
            catch (Throwable t) {
                this.logException(caller, t, sources);
                return t.getMessage();
            }
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_ROUND;
    }

    @Override
    public String shortDescription() {
        return "Rounds the given argument to an integer";
    }
}

