/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class ServerLogFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_SERVERLOG = "Usage: ${serverlog([lines=50])}. Example: ${serverlog(200)}";
    public static final String ERROR_MESSAGE_SERVERLOG_JS = "Usage: ${{Structr.serverlog([n=50])}}. Example: ${{Structr.serverlog(200)}}";
    private static final Logger logger = LoggerFactory.getLogger((String)ServerLogFunction.class.getName());

    @Override
    public String getName() {
        return "serverlog()";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        int lines = 50;
        if (sources != null && sources.length > 0 && sources[0] instanceof Number) {
            lines = ((Number)sources[0]).intValue();
        }
        try (ReversedLinesFileReader reader = new ReversedLinesFileReader(this.getServerlogFile(), Charset.forName("utf-8"));){
            StringBuilder sb = new StringBuilder();
            while (lines > 0) {
                String line = reader.readLine();
                if (line == null) {
                    lines = 0;
                    continue;
                }
                sb.insert(0, line.concat("\n"));
                --lines;
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ex) {
            logger.warn("", (Throwable)ex);
            return "";
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_SERVERLOG_JS : ERROR_MESSAGE_SERVERLOG;
    }

    @Override
    public String shortDescription() {
        return "Returns the last n lines from the server log file";
    }
}

