/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class SizeFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_SIZE = "Usage: ${size(collection)}. Example: ${size(this.children)}";

    @Override
    public String getName() {
        return "size()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object source : sources) {
            if (source == null) continue;
            if (source instanceof Collection) {
                for (Object obj : (Collection)source) {
                    if (obj == null || "___NULL___".equals(obj)) continue;
                    list.add(obj);
                }
            } else if (source.getClass().isArray()) {
                list.addAll(Arrays.asList((Object[])source));
            } else if (source != null && !"___NULL___".equals(source)) {
                list.add(source);
            }
            return list.size();
        }
        return 0;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_SIZE;
    }

    @Override
    public String shortDescription() {
        return "Returns the size of the given collection";
    }
}

