/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class SplitFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_SPLIT = "Usage: ${split(value)}. Example: ${split(this.commaSeparatedItems)}";

    @Override
    public String getName() {
        return "split()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 1, 2)) {
                return null;
            }
            String toSplit = sources[0].toString();
            String splitExpr = "[,;\\s]+";
            if (sources.length >= 2) {
                splitExpr = sources[1].toString();
                return Arrays.asList(StringUtils.split((String)toSplit, (String)splitExpr));
            }
            return Arrays.asList(toSplit.split(splitExpr));
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_SPLIT;
    }

    @Override
    public String shortDescription() {
        return "Splits the given string";
    }
}

