/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class SubstringFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_SUBSTRING = "Usage: ${substring(string, start, length)}. Example: ${substring(this.name, 19, 3)}";

    @Override
    public String getName() {
        return "substring()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 2, 3)) {
            String source = sources[0].toString();
            int sourceLength = source.length();
            int beginIndex = this.parseInt(sources[1]);
            int length = sources.length == 3 ? this.parseInt(sources[2]) : sourceLength - beginIndex;
            int endIndex = beginIndex + length;
            if (beginIndex >= 0 && beginIndex < sourceLength && endIndex >= beginIndex && endIndex <= sourceLength) {
                return source.substring(beginIndex, endIndex);
            }
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_SUBSTRING;
    }

    @Override
    public String shortDescription() {
        return "Returns the substring of the given string";
    }
}

