/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class SubtFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_SUBT = "Usage: ${subt(value1, value2)}. Example: ${subt(5, 2)}";

    @Override
    public String getName() {
        return "subt()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasMinLengthAndAllElementsNotNull(sources, 2)) {
            try {
                double result = Double.parseDouble(sources[0].toString());
                for (int i = 1; i < sources.length; ++i) {
                    result -= Double.parseDouble(sources[i].toString());
                }
                return result;
            }
            catch (Throwable t) {
                this.logException(caller, t, sources);
                return t.getMessage();
            }
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_SUBT;
    }

    @Override
    public String shortDescription() {
        return "Substracts the second argument from the first argument";
    }
}

