/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Date;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class ToDateFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_TO_DATE = "Usage: ${to_date(value)}. Example: ${to_date(1473201885000)}";
    public static final String ERROR_MESSAGE_TO_DATE_JS = "Usage: ${{Structr.toDate(value)}}. Example: ${{Structr.toDate(1473201885000)}}";

    @Override
    public String getName() {
        return "to_date()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources != null && sources.length == 1 && sources[0] != null && sources[0] instanceof Number) {
            try {
                Long timestamp = 0L;
                if (sources[0] instanceof Double) {
                    timestamp = Math.round((Double)sources[0]);
                } else if (sources[0] instanceof Integer || sources[0] instanceof Long) {
                    timestamp = (Long)sources[0];
                } else {
                    throw new UnsupportedOperationException();
                }
                return new Date(timestamp);
            }
            catch (Throwable throwable) {}
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_TO_DATE_JS : ERROR_MESSAGE_TO_DATE;
    }

    @Override
    public String shortDescription() {
        return "Converts the given number to a date";
    }
}

