/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.SchemaHelper;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class TypeInfoFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_TYPE_INFO = "Usage: ${type_info(type[, view])}. Example ${type_info('User', 'public')}";
    public static final String ERROR_MESSAGE_TYPE_INFO_JS = "Usage: ${Structr.type_info(type[, view])}. Example ${Structr.type_info('User', 'public')}";

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 1, 2)) {
                String typeName = sources[0].toString();
                Class type = SchemaHelper.getEntityClassForRawType(typeName);
                String viewName = sources.length == 2 ? sources[1].toString() : null;
                return SchemaHelper.getSchemaTypeInfo(ctx.getSecurityContext(), typeName, type, viewName);
            }
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_TYPE_INFO_JS : ERROR_MESSAGE_TYPE_INFO;
    }

    @Override
    public String shortDescription() {
        return "Returns the type information for the specified type";
    }

    @Override
    public String getName() {
        return "type_info()";
    }
}

