/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.property.PropertyKey;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class ValuesFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_VALUES = "Usage: ${values(entity, viewName)}. Example: ${values(this, \"ui\")}";

    @Override
    public String getName() {
        return "values()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources.length >= 2 && sources[0] instanceof GraphObject) {
            LinkedHashSet values = new LinkedHashSet();
            GraphObject source = (GraphObject)sources[0];
            for (PropertyKey key : source.getPropertyKeys(sources[1].toString())) {
                values.add(source.getProperty(key));
            }
            return new LinkedList(values);
        }
        if (sources.length >= 1) {
            if (sources[0] instanceof GraphObjectMap) {
                return new LinkedList(((GraphObjectMap)sources[0]).values());
            }
            if (sources[0] instanceof Map) {
                return new LinkedList(((Map)sources[0]).values());
            }
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_VALUES;
    }

    @Override
    public String shortDescription() {
        return "Returns the property values of the given entity";
    }
}

