/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class WriteFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_WRITE = "Usage: ${write(filename, value)}. Example: ${write(\"text.txt\", this.name)}";

    @Override
    public String getName() {
        return "write()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        block18: {
            if (this.arrayHasMinLengthAndAllElementsNotNull(sources, 1)) {
                try {
                    String sandboxFilename = this.getSandboxFileName(sources[0].toString());
                    if (sandboxFilename == null) break block18;
                    File file = new File(sandboxFilename);
                    if (!file.exists()) {
                        try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file, false));){
                            for (int i = 1; i < sources.length; ++i) {
                                if (sources[i] == null) continue;
                                IOUtils.write((String)sources[i].toString(), (Writer)writer);
                            }
                            ((Writer)writer).flush();
                            break block18;
                        }
                    }
                    logger.error("Trying to overwrite an existing file, please use append() for that purpose.");
                }
                catch (IOException ioex) {
                    this.logException(caller, ioex, sources);
                }
            } else {
                this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            }
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_WRITE;
    }

    @Override
    public String shortDescription() {
        return "Writes to the given file in the exchange directoy";
    }
}

