/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_XML = "Usage: ${xml(xmlSource)}. Example: ${xpath(xml(this.xmlSource), \"/test/testValue\")}";

    @Override
    public String getName() {
        return "xml()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1) || !(sources[0] instanceof String)) {
                return null;
            }
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                if (builder != null) {
                    String xml = (String)sources[0];
                    StringReader reader = new StringReader(xml);
                    InputSource src = new InputSource(reader);
                    return builder.parse(src);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                this.logException(caller, ex, sources);
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_XML;
    }

    @Override
    public String shortDescription() {
        return "Parses the given string to an XML DOM";
    }
}

