/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.graph.Node;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.BulkGraphOperation;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.schema.SchemaHelper;

public class BulkChangeNodePropertyKeyCommand
extends NodeServiceCommand
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)BulkChangeNodePropertyKeyCommand.class.getName());

    @Override
    public void execute(final Map<String, Object> properties) throws FrameworkException {
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        SecurityContext superUserContext = SecurityContext.getSuperUserInstance();
        NodeFactory nodeFactory = new NodeFactory(superUserContext);
        String type = null;
        final String oldKey = (String)properties.get("oldKey");
        final String newKey = (String)properties.get("newKey");
        if (graphDb != null && StringUtils.isNotBlank((CharSequence)oldKey) && StringUtils.isNotBlank((CharSequence)newKey)) {
            Tx tx;
            Iterator nodeIterator = null;
            if (properties.containsKey(AbstractNode.type.dbName())) {
                type = (String)properties.get(AbstractNode.type.dbName());
                tx = StructrApp.getInstance().tx();
                Throwable throwable = null;
                try {
                    nodeIterator = StructrApp.getInstance(this.securityContext).nodeQuery(SchemaHelper.getEntityClassForRawType(type)).getResult().getResults().iterator();
                    tx.success();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
                properties.remove(AbstractNode.type.dbName());
            } else {
                tx = StructrApp.getInstance().tx();
                Throwable throwable = null;
                try {
                    nodeIterator = Iterables.map(nodeFactory, (Iterable)graphDb.getAllNodes()).iterator();
                    tx.success();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            long count = this.bulkGraphOperation(this.securityContext, nodeIterator, 1000L, "ChangeNodePropertyKey", new BulkGraphOperation<AbstractNode>(){

                @Override
                public void handleGraphObject(SecurityContext securityContext, AbstractNode node) {
                    for (Map.Entry entry : properties.entrySet()) {
                        String key = (String)entry.getKey();
                        PropertyKey propertyKey = StructrApp.getConfiguration().getPropertyKeyForDatabaseName(node.getClass(), key);
                        if (propertyKey == null) continue;
                        Node dbNode = node.getNode();
                        if (dbNode.hasProperty(newKey)) {
                            logger.error("Node {} has already a property with key {}", new Object[]{node, newKey});
                            throw new IllegalStateException("Node has already a property of the new key");
                        }
                        if (dbNode.hasProperty(oldKey)) {
                            dbNode.setProperty(newKey, dbNode.getProperty(oldKey));
                            dbNode.removeProperty(oldKey);
                        }
                        node.updateInIndex();
                    }
                }

                @Override
                public void handleThrowable(SecurityContext securityContext, Throwable t, AbstractNode node) {
                    logger.warn("Unable to set properties of node {}: {}", new Object[]{node.getUuid(), t.getMessage()});
                }

                @Override
                public void handleTransactionFailure(SecurityContext securityContext, Throwable t) {
                    logger.warn("Unable to set node properties: {}", (Object)t.getMessage());
                }
            });
            logger.info("Fixed {} nodes ...", (Object)count);
        } else {
            logger.info("No values for oldKey and/or newKey found, aborting.");
        }
        logger.info("Done");
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    @Override
    public boolean requiresFlushingOfCaches() {
        return false;
    }
}

