/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.structr.api.DatabaseService;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.StructrAndSpatialPredicate;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.BulkGraphOperation;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.TransactionPostProcess;
import org.structr.core.graph.Tx;
import org.structr.core.property.TypeProperty;

public class BulkCreateLabelsCommand
extends NodeServiceCommand
implements MaintenanceCommand,
TransactionPostProcess {
    @Override
    public void execute(Map<String, Object> attributes) {
        String entityType = (String)attributes.get("type");
        final DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        SecurityContext superUserContext = SecurityContext.getSuperUserInstance();
        NodeFactory nodeFactory = new NodeFactory(superUserContext);
        Iterator nodeIterator = null;
        try (Tx tx = StructrApp.getInstance().tx();){
            nodeIterator = Iterables.map(nodeFactory, (Iterable)Iterables.filter(new StructrAndSpatialPredicate(true, false, false), (Iterable)graphDb.getNodesByTypeProperty(entityType))).iterator();
            tx.success();
        }
        catch (FrameworkException fex) {
            this.warn("Exception while creating all nodes iterator.", fex);
        }
        if (entityType == null) {
            this.info("Node type not set or no entity class found. Starting creation of labels for all nodes.", new Object[0]);
        } else {
            this.info("Starting creation of labels for all nodes of type {}", entityType);
        }
        long count = this.bulkGraphOperation(this.securityContext, nodeIterator, 10000L, "CreateLabels", new BulkGraphOperation<AbstractNode>(){

            @Override
            public void handleGraphObject(SecurityContext securityContext, AbstractNode node) {
                TypeProperty.updateLabels(graphDb, node, node.getClass());
            }

            @Override
            public void handleThrowable(SecurityContext securityContext, Throwable t, AbstractNode node) {
                BulkCreateLabelsCommand.this.warn("Unable to create labels for node {}: {}", node, t.getMessage());
            }

            @Override
            public void handleTransactionFailure(SecurityContext securityContext, Throwable t) {
                BulkCreateLabelsCommand.this.warn("Unable to create labels for node: {}", t.getMessage());
            }
        });
        this.info("Done with creating labels on {} nodes", count);
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    @Override
    public boolean execute(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        this.execute(Collections.EMPTY_MAP);
        return true;
    }

    @Override
    public boolean requiresFlushingOfCaches() {
        return true;
    }
}

