/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.graph.Node;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.BulkGraphOperation;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.Tx;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.schema.SchemaHelper;

public class BulkFixNodePropertiesCommand
extends NodeServiceCommand
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)BulkFixNodePropertiesCommand.class.getName());

    @Override
    public void execute(Map<String, Object> attributes) throws FrameworkException {
        Class type;
        final String propertyName = (String)attributes.get("name");
        String entityTypeName = (String)attributes.get("type");
        if (entityTypeName != null && (type = SchemaHelper.getEntityClassForRawType(entityTypeName)) != null) {
            Iterator nodeIterator = null;
            try (Tx tx = StructrApp.getInstance().tx();){
                nodeIterator = StructrApp.getInstance(this.securityContext).nodeQuery(type).getAsList().iterator();
                tx.success();
            }
            if (type != null) {
                logger.info("Trying to fix properties of all {} nodes", (Object)type.getSimpleName());
                long nodeCount = this.bulkGraphOperation(this.securityContext, nodeIterator, 100L, "FixNodeProperties", new BulkGraphOperation<AbstractNode>(){

                    private void fixProperty(AbstractNode node, Property propertyToFix) {
                        PropertyConverter<Object, ?> converter;
                        Node databaseNode = node.getNode();
                        if (databaseNode.hasProperty(propertyToFix.dbName()) && (converter = propertyToFix.databaseConverter(BulkFixNodePropertiesCommand.this.securityContext, node)) != null) {
                            try {
                                Object value = databaseNode.getProperty(propertyToFix.dbName());
                                converter.revert(value);
                            }
                            catch (ClassCastException cce) {
                                String databaseName = propertyToFix.dbName();
                                Object databaseValue = databaseNode.getProperty(databaseName);
                                Object correctedValue = propertyToFix.fixDatabaseProperty(databaseValue);
                                if (databaseValue != null && correctedValue != null) {
                                    try {
                                        databaseNode.setProperty(databaseName, correctedValue);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Unable to fix property {} of {} with UUID {} which is of type {}", new Object[]{propertyToFix.dbName(), type.getSimpleName(), node.getUuid(), databaseValue != null ? databaseValue.getClass() : "null"});
                                    }
                                }
                            }
                            catch (Throwable t) {
                                logger.warn("", t);
                            }
                        }
                    }

                    @Override
                    public void handleGraphObject(SecurityContext securityContext, AbstractNode node) {
                        if (propertyName != null) {
                            PropertyKey key = StructrApp.getConfiguration().getPropertyKeyForDatabaseName(type, propertyName);
                            if (key != null && key instanceof Property) {
                                this.fixProperty(node, (Property)key);
                            }
                        } else {
                            for (PropertyKey key : node.getPropertyKeys("all")) {
                                if (!(key instanceof Property)) continue;
                                this.fixProperty(node, (Property)key);
                            }
                        }
                    }
                });
                logger.info("Fixed {} nodes", (Object)nodeCount);
                return;
            }
        }
        logger.info("Unable to determine property and/or entity type to fix.");
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    @Override
    public boolean requiresFlushingOfCaches() {
        return false;
    }
}

