/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;

public abstract class BulkGraphOperation<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)BulkGraphOperation.class.getName());

    public abstract void handleGraphObject(SecurityContext var1, T var2) throws FrameworkException;

    public void handleThrowable(SecurityContext securityContext, Throwable t, T currentObject) {
        logger.warn("Exception in bulk graph operation.", t);
    }

    public void handleTransactionFailure(SecurityContext securityContext, Throwable t) {
        logger.warn("Transaction failure in bulk graph operation.", t);
    }

    public Predicate<Long> getCondition() {
        return null;
    }

    public boolean doValidation() {
        return true;
    }

    public boolean doCallbacks() {
        return false;
    }

    public boolean doNotifications() {
        return false;
    }
}

