/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.BulkGraphOperation;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.graph.Tx;
import org.structr.core.property.TypeProperty;

public class BulkSetUuidCommand
extends NodeServiceCommand
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)BulkSetUuidCommand.class.getName());

    @Override
    public void execute(Map<String, Object> attributes) throws FrameworkException {
        String nodeType = (String)attributes.get("type");
        String relType = (String)attributes.get("relType");
        Boolean allNodes = (Boolean)attributes.get("allNodes");
        Boolean allRels = (Boolean)attributes.get("allRels");
        final DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        SecurityContext superUserContext = SecurityContext.getSuperUserInstance();
        NodeFactory nodeFactory = new NodeFactory(superUserContext);
        RelationshipFactory relFactory = new RelationshipFactory(superUserContext);
        if (nodeType != null || Boolean.TRUE.equals(allNodes)) {
            Iterator nodeIterator = null;
            try (Tx tx = StructrApp.getInstance().tx();){
                if (Boolean.TRUE.equals(allNodes)) {
                    nodeIterator = Iterables.map(nodeFactory, (Iterable)graphDb.getAllNodes()).iterator();
                    this.info("Start setting UUID on all nodes", new Object[0]);
                } else {
                    nodeIterator = Iterables.map(nodeFactory, (Iterable)graphDb.getNodesByTypeProperty(nodeType)).iterator();
                    this.info("Start setting UUID on nodes of type {}", nodeType);
                }
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("Exception while creating all nodes iterator.", (Throwable)fex);
            }
            long count = this.bulkGraphOperation(this.securityContext, nodeIterator, 1000L, "SetNodeUuid", new BulkGraphOperation<AbstractNode>(){

                @Override
                public void handleGraphObject(SecurityContext securityContext, AbstractNode node) {
                    try {
                        if (node.getProperty(GraphObject.id) == null) {
                            node.unlockSystemPropertiesOnce();
                            node.setProperty(GraphObject.id, NodeServiceCommand.getNextUuid());
                        }
                        TypeProperty.updateLabels(graphDb, node, node.getClass());
                    }
                    catch (FrameworkException fex) {
                        logger.warn("Unable to set UUID of node {}", (Object)node, (Object)fex);
                    }
                }

                @Override
                public void handleThrowable(SecurityContext securityContext, Throwable t, AbstractNode node) {
                    logger.warn("Unable to set UUID of node {}", (Object)node, (Object)t);
                }

                @Override
                public void handleTransactionFailure(SecurityContext securityContext, Throwable t) {
                    logger.warn("Unable to set UUID on node", t);
                }

                @Override
                public boolean doValidation() {
                    return false;
                }
            });
            this.info("Done with setting UUID on {} nodes", count);
            return;
        }
        if (relType != null || Boolean.TRUE.equals(allRels)) {
            Iterator relIterator = null;
            try (Tx tx = StructrApp.getInstance().tx();){
                if (Boolean.TRUE.equals(allRels)) {
                    relIterator = Iterables.map(relFactory, (Iterable)graphDb.getAllRelationships()).iterator();
                    this.info("Start setting UUID on all rels", relType);
                } else {
                    relIterator = Iterables.map(relFactory, (Iterable)graphDb.getRelationshipsByType(relType)).iterator();
                    this.info("Start setting UUID on rels of type {}", relType);
                }
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("Exception while creating all nodes iterator.", (Throwable)fex);
            }
            long count = this.bulkGraphOperation(this.securityContext, relIterator, 1000L, "SetRelationshipUuid", new BulkGraphOperation<AbstractRelationship>(){

                @Override
                public void handleGraphObject(SecurityContext securityContext, AbstractRelationship rel) {
                    try {
                        if (rel.getProperty(GraphObject.id) == null) {
                            rel.unlockSystemPropertiesOnce();
                            rel.setProperty(GraphObject.id, NodeServiceCommand.getNextUuid());
                        }
                    }
                    catch (FrameworkException fex) {
                        logger.warn("Unable to set UUID of relationship {}: {}", new Object[]{rel, fex.getMessage()});
                    }
                }

                @Override
                public void handleThrowable(SecurityContext securityContext, Throwable t, AbstractRelationship rel) {
                    logger.warn("Unable to set UUID of relationship {}: {}", (Object)rel, (Object)t.getMessage());
                }

                @Override
                public void handleTransactionFailure(SecurityContext securityContext, Throwable t) {
                    logger.warn("Unable to set UUID on relationships {}", (Object)t.toString());
                }

                @Override
                public boolean doValidation() {
                    return false;
                }
            });
            this.info("Done with setting UUID on {} relationships", count);
            return;
        }
        this.info("Unable to determine entity type to set UUID.", new Object[0]);
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    @Override
    public boolean requiresFlushingOfCaches() {
        return true;
    }
}

