/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.BulkGraphOperation;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.Tx;

public class ClearDatabase
extends NodeServiceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)ClearDatabase.class.getName());

    public void execute() throws FrameworkException {
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        NodeFactory nodeFactory = new NodeFactory(this.securityContext);
        if (graphDb != null) {
            Iterator<NodeInterface> nodeIterator = null;
            final App app = StructrApp.getInstance();
            try (Tx tx = app.tx();){
                nodeIterator = app.nodeQuery(NodeInterface.class).getAsList().iterator();
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("Exception while creating all nodes iterator.", (Throwable)fex);
            }
            long deletedNodes = this.bulkGraphOperation(this.securityContext, nodeIterator, 1000L, "ClearDatabase", new BulkGraphOperation<NodeInterface>(){

                @Override
                public void handleGraphObject(SecurityContext securityContext, NodeInterface node) {
                    if (node.getProperty(GraphObject.id) != null) {
                        try {
                            app.delete(node);
                        }
                        catch (FrameworkException fex) {
                            logger.warn("Unable to delete node {}: {}", new Object[]{node.getUuid(), fex.getMessage()});
                        }
                    }
                }

                @Override
                public void handleThrowable(SecurityContext securityContext, Throwable t, NodeInterface node) {
                    logger.warn("Unable to delete node {}: {}", new Object[]{node.getUuid(), t.getMessage()});
                }

                @Override
                public void handleTransactionFailure(SecurityContext securityContext, Throwable t) {
                    logger.warn("Unable to clear database: {}", (Object)t.getMessage());
                }
            });
            logger.info("Finished deleting {} nodes", (Object)deletedNodes);
        }
    }
}

