/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.graph.Relationship;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.TransactionCommand;

public class DeleteRelationshipCommand
extends NodeServiceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)DeleteRelationshipCommand.class.getName());

    public Object execute(Relationship rel) throws FrameworkException {
        RelationshipFactory relFactory = new RelationshipFactory(this.securityContext);
        return this.execute((RelationshipInterface)relFactory.instantiate(rel), false);
    }

    public Object execute(RelationshipInterface rel) {
        return this.execute(rel, false);
    }

    public Object execute(RelationshipInterface rel, boolean passiveDeletion) {
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        if (graphDb != null && rel != null) {
            if (rel.getProperty(AbstractRelationship.id) == null) {
                logger.warn("Will not delete relationship which has no UUID: {} --[:{}]-->{}", new Object[]{rel.getSourceNode(), rel.getType(), rel.getTargetNode()});
                return null;
            }
            Relationship relToDelete = rel.getRelationship();
            RelationshipInterface finalRel = rel;
            TransactionCommand.relationshipDeleted(this.securityContext.getCachedUser(), finalRel, passiveDeletion);
            finalRel.onRelationshipDeletion();
            finalRel.removeFromIndex();
            relToDelete.delete();
        }
        return null;
    }
}

