/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.NotFoundException;
import org.structr.api.graph.Relationship;
import org.structr.api.util.Iterables;
import org.structr.common.FactoryDefinition;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.IdNotFoundToken;
import org.structr.core.Adapter;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.schema.SchemaHelper;

public abstract class Factory<S, T extends GraphObject>
implements Adapter<S, T>,
Function<S, T> {
    private static final Logger logger = LoggerFactory.getLogger((String)Factory.class.getName());
    public static final ExecutorService service = Executors.newCachedThreadPool();
    public static final int DEFAULT_PAGE_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_PAGE = 1;
    public static final int RESULT_COUNT_ACCURATE_LIMIT = 5000;
    protected FactoryDefinition factoryDefinition = StructrApp.getConfiguration().getFactoryDefinition();
    protected FactoryProfile factoryProfile = null;

    public Factory(SecurityContext securityContext) {
        this.factoryProfile = new FactoryProfile(securityContext);
    }

    public Factory(SecurityContext securityContext, boolean includeDeletedAndHidden, boolean publicOnly) {
        this.factoryProfile = new FactoryProfile(securityContext, includeDeletedAndHidden, publicOnly);
    }

    public Factory(SecurityContext securityContext, int pageSize, int page, String offsetId) {
        this.factoryProfile = new FactoryProfile(securityContext);
        this.factoryProfile.setPageSize(pageSize);
        this.factoryProfile.setPage(page);
        this.factoryProfile.setOffsetId(offsetId);
    }

    public Factory(SecurityContext securityContext, boolean includeDeletedAndHidden, boolean publicOnly, int pageSize, int page, String offsetId) {
        this.factoryProfile = new FactoryProfile(securityContext, includeDeletedAndHidden, publicOnly, pageSize, page, offsetId);
    }

    public abstract T instantiate(S var1);

    public abstract T instantiate(S var1, Relationship var2);

    public abstract T instantiateWithType(S var1, Class<T> var2, Relationship var3, boolean var4) throws FrameworkException;

    public abstract T instantiate(S var1, boolean var2, boolean var3) throws FrameworkException;

    public abstract T instantiateDummy(S var1, String var2) throws FrameworkException;

    public Result instantiateAll(Iterable<S> input) throws FrameworkException {
        List<T> objects = this.bulkInstantiate(input);
        return new Result<T>(objects, objects.size(), true, false);
    }

    public Result instantiate(Iterable<S> input) throws FrameworkException {
        if (input != null) {
            if (this.factoryProfile.getOffsetId() != null) {
                return this.resultWithOffsetId(input);
            }
            return this.resultWithoutOffsetId(input);
        }
        return Result.EMPTY_RESULT;
    }

    public List<T> bulkInstantiate(Iterable<S> input) throws FrameworkException {
        LinkedList<T> nodes = new LinkedList<T>();
        if (input != null && input.iterator().hasNext()) {
            for (S node : input) {
                T n = this.instantiate(node);
                if (n == null) continue;
                nodes.add(n);
            }
        }
        return nodes;
    }

    @Override
    public T adapt(S s) {
        return this.instantiate(s);
    }

    @Override
    public T apply(S from) {
        return (T)this.adapt((Object)from);
    }

    protected Class<T> getClassForName(String rawType) {
        return SchemaHelper.getEntityClassForRawType(rawType);
    }

    protected List<S> read(Iterable<S> iterable) {
        LinkedList<S> nodes = new LinkedList<S>();
        Iterator<S> it = iterable.iterator();
        while (it.hasNext()) {
            nodes.add(it.next());
        }
        return nodes;
    }

    protected Result resultWithOffsetId(Iterable<S> input) throws FrameworkException {
        Object n;
        List list = Iterables.toList(input);
        int size = list.size();
        int pageSize = Math.min(size, this.factoryProfile.getPageSize());
        int page = this.factoryProfile.getPage();
        String offsetId = this.factoryProfile.getOffsetId();
        LinkedList<GraphObject> elements = new LinkedList<GraphObject>();
        int position = 0;
        int count = 0;
        int offset = 0;
        Iterator iterator = list.iterator();
        LinkedList<Object> nodesUpToOffset = new LinkedList<Object>();
        int i = 0;
        boolean gotOffset = false;
        while (iterator.hasNext()) {
            n = this.instantiate(iterator.next());
            if (n == null) continue;
            nodesUpToOffset.add(n);
            if (gotOffset) continue;
            if (!offsetId.equals(n.getUuid())) {
                ++i;
                continue;
            }
            gotOffset = true;
            offset = page > 0 ? i : i + page * pageSize;
            break;
        }
        if (!nodesUpToOffset.isEmpty() && !gotOffset) {
            throw new FrameworkException(404, "Node with ID " + offsetId + " not found", new IdNotFoundToken("offsetId", offsetId));
        }
        if (offset < 0) {
            nodesUpToOffset.remove(nodesUpToOffset.size() - 1);
            return new Result(nodesUpToOffset, size, true, false);
        }
        for (GraphObject graphObject : nodesUpToOffset) {
            if (graphObject == null || ++position <= offset) continue;
            if (++count > pageSize) {
                return new Result(elements, size, true, false);
            }
            elements.add(graphObject);
        }
        while (iterator.hasNext()) {
            n = this.instantiate(iterator.next());
            if (n == null || ++position <= offset) continue;
            if (++count > pageSize) {
                return new Result(elements, size, true, false);
            }
            elements.add((GraphObject)n);
        }
        return new Result(elements, size, true, false);
    }

    protected Result resultWithoutOffsetId(Iterable<S> input) throws FrameworkException {
        int pageSize = this.factoryProfile.getPageSize();
        int page = this.factoryProfile.getPage();
        if (page < 0) {
            List<S> rawNodes = this.read(input);
            int size = rawNodes.size();
            int fromIndex = Math.max(0, size + page * pageSize);
            LinkedList<T> nodes = new LinkedList<T>();
            int toIndex = Math.min(size, fromIndex + pageSize);
            for (S n : rawNodes.subList(fromIndex, toIndex)) {
                nodes.add(this.instantiate(n));
            }
            return new Result(nodes, size, true, false);
        }
        int fromIndex = pageSize == Integer.MAX_VALUE ? 0 : (page - 1) * pageSize;
        return this.page(input, fromIndex, pageSize);
    }

    protected Result page(Iterable<S> input, int offset, int pageSize) throws FrameworkException {
        SecurityContext securityContext = this.factoryProfile.getSecurityContext();
        AtomicBoolean keepRunning = new AtomicBoolean(true);
        AtomicInteger overallCount = new AtomicInteger();
        AtomicInteger processedItems = new AtomicInteger();
        LinkedList nodes = new LinkedList();
        LinkedList failed = new LinkedList();
        boolean preventFullCount = securityContext.ignoreResultCount();
        ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
        LinkedList futures = new LinkedList();
        boolean threadCount = true;
        int rawCount = 0;
        for (S item2 : input) {
            queue.add(new Item<S>(rawCount++, item2));
        }
        InstantiationWorker worker = new InstantiationWorker(securityContext, queue, failed, nodes, offset, pageSize, preventFullCount);
        worker.setProcessedItems(processedItems);
        worker.setOverallCount(overallCount);
        worker.setKeepRunning(keepRunning);
        worker.doRun();
        failed.stream().forEach(item -> nodes.add(new Item<T>(item.index, this.instantiate(item.item))));
        Collections.sort(nodes);
        int size = nodes.size();
        int from = Math.min(offset, size);
        int to = Math.min(offset + pageSize, size);
        LinkedList output = new LinkedList();
        nodes.subList(from, to).stream().forEach(item -> output.add(item.item));
        return new Result(output, overallCount.get(), true, false);
    }

    protected class FactoryProfile {
        private boolean includeDeletedAndHidden = true;
        private String offsetId = null;
        private boolean publicOnly = false;
        private int pageSize = Integer.MAX_VALUE;
        private int page = 1;
        private SecurityContext securityContext = null;

        public FactoryProfile(SecurityContext securityContext) {
            this.securityContext = securityContext;
        }

        public FactoryProfile(SecurityContext securityContext, boolean includeDeletedAndHidden, boolean publicOnly) {
            this.securityContext = securityContext;
            this.includeDeletedAndHidden = includeDeletedAndHidden;
            this.publicOnly = publicOnly;
        }

        public FactoryProfile(SecurityContext securityContext, boolean includeDeletedAndHidden, boolean publicOnly, int pageSize, int page, String offsetId) {
            this.securityContext = securityContext;
            this.includeDeletedAndHidden = includeDeletedAndHidden;
            this.publicOnly = publicOnly;
            this.pageSize = pageSize;
            this.page = page;
            this.offsetId = offsetId;
        }

        public boolean includeDeletedAndHidden() {
            return this.includeDeletedAndHidden;
        }

        public boolean publicOnly() {
            return this.publicOnly;
        }

        public String getOffsetId() {
            return this.offsetId;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public int getPage() {
            return this.page;
        }

        public SecurityContext getSecurityContext() {
            return this.securityContext;
        }

        public void setIncludeDeletedAndHidden(boolean includeDeletedAndHidden) {
            this.includeDeletedAndHidden = includeDeletedAndHidden;
        }

        public void setOffsetId(String offsetId) {
            this.offsetId = offsetId;
        }

        public void setPublicOnly(boolean publicOnly) {
            this.publicOnly = publicOnly;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        public void setPage(int page) {
            this.page = page;
        }

        public void setSecurityContext(SecurityContext securityContext) {
            this.securityContext = securityContext;
        }
    }

    private class Item<X>
    implements Comparable<Item<X>> {
        public int index = 0;
        public X item = null;

        public Item(int index, X item) {
            this.index = index;
            this.item = item;
        }

        @Override
        public int compareTo(Item<X> o) {
            return Integer.valueOf(this.index).compareTo(o.index);
        }
    }

    private class InstantiationWorker
    implements Runnable {
        private final SecurityContext securityContext;
        private final Queue<Item<S>> source;
        private final List<Item<T>> nodes;
        private final List<Item<S>> failed;
        private AtomicInteger processedItems = null;
        private AtomicInteger overallCount = null;
        private AtomicBoolean keepRunning = null;
        private boolean dontCheckCount = false;
        private boolean doLogOutput = false;
        private int pageSize = 0;
        private int offset = 0;

        public InstantiationWorker(SecurityContext securityContext, Queue<Item<S>> source, List<Item<S>> failed, List<Item<T>> nodes, int offset, int pageSize, boolean dontCheckCount) {
            this.securityContext = securityContext;
            this.offset = offset;
            this.source = source;
            this.dontCheckCount = dontCheckCount;
            this.pageSize = pageSize;
            this.nodes = nodes;
            this.failed = failed;
        }

        @Override
        public void run() {
            try (Tx tx = StructrApp.getInstance(this.securityContext).tx();){
                this.doRun();
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() {
            Item item;
            long t0;
            long t1 = t0 = System.currentTimeMillis();
            do {
                if ((item = this.source.poll()) != null) {
                    this.processedItems.incrementAndGet();
                    Object n = null;
                    try {
                        n = Factory.this.instantiate(item.item);
                    }
                    catch (NotFoundException nfe) {
                        List list = this.failed;
                        synchronized (list) {
                            this.failed.add(item);
                        }
                    }
                    if (n != null) {
                        this.overallCount.incrementAndGet();
                        List list = this.nodes;
                        synchronized (list) {
                            this.nodes.add(new Item<Object>(item.index, n));
                        }
                        if (this.dontCheckCount && this.overallCount.get() > this.offset + this.pageSize) {
                            this.keepRunning.set(false);
                        }
                    }
                }
                if (!this.doLogOutput || System.currentTimeMillis() - t1 <= 2000L) continue;
                t1 = System.currentTimeMillis();
                logger.info("Parallel instantiation: checked {} nodes so far", (Object)this.processedItems.get());
            } while (item != null && this.keepRunning.get());
        }

        public void setKeepRunning(AtomicBoolean keepRunning) {
            this.keepRunning = keepRunning;
        }

        public void setProcessedItems(AtomicInteger processedItems) {
            this.processedItems = processedItems;
        }

        public void setOverallCount(AtomicInteger overallCount) {
            this.overallCount = overallCount;
        }

        public void pleaseLog(boolean doLogOutput) {
            this.doLogOutput = doLogOutput;
        }
    }
}

