/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.graph.Relationship;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipFactory;

public class FindRelationshipCommand<T extends AbstractRelationship>
extends NodeServiceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)FindRelationshipCommand.class.getName());

    public T execute(Relationship relationship) throws FrameworkException {
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        RelationshipFactory relationshipFactory = new RelationshipFactory(this.securityContext);
        if (graphDb != null) {
            return (T)((AbstractRelationship)relationshipFactory.instantiate(relationship));
        }
        return null;
    }

    public T execute(Long id) throws FrameworkException {
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        RelationshipFactory relationshipFactory = new RelationshipFactory(this.securityContext);
        if (graphDb != null) {
            return (T)((AbstractRelationship)relationshipFactory.instantiate(graphDb.getRelationshipById(id.longValue())));
        }
        return null;
    }

    public T execute(String idString) throws FrameworkException {
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        RelationshipFactory relationshipFactory = new RelationshipFactory(this.securityContext);
        if (graphDb != null) {
            try {
                return (T)((AbstractRelationship)relationshipFactory.instantiate(graphDb.getRelationshipById(Long.parseLong(idString))));
            }
            catch (NumberFormatException ex) {
                logger.debug("Could not parse {} to number", (Object)idString);
            }
        }
        return null;
    }
}

