/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.bolt.wrapper.NodeWrapper;
import org.structr.bolt.wrapper.RelationshipWrapper;
import org.structr.common.AccessPathCache;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeServiceCommand;

public class FlushCachesCommand
extends NodeServiceCommand
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)FlushCachesCommand.class.getName());

    @Override
    public void execute(Map<String, Object> attributes) throws FrameworkException {
        logger.info("Clearing all caches.");
        FlushCachesCommand.flushAll();
        logger.info("Done");
    }

    public static void flushAll() {
        NodeWrapper.clearCache();
        RelationshipWrapper.clearCache();
        AccessPathCache.invalidate();
        App app = StructrApp.getInstance();
        app.invalidateCache();
        app.getDatabaseService().invalidateQueryCache();
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return true;
    }

    @Override
    public boolean requiresFlushingOfCaches() {
        return false;
    }
}

