/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.api.graph.RelationshipType;
import org.structr.common.RelType;
import org.structr.common.SecurityContext;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.entity.Principal;
import org.structr.core.graph.GraphObjectModificationState;
import org.structr.core.graph.ModificationEvent;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.TransactionPostProcess;
import org.structr.core.property.PropertyKey;

public class ModificationQueue {
    private static final Logger logger = LoggerFactory.getLogger((String)ModificationQueue.class.getName());
    private final ConcurrentSkipListMap<String, GraphObjectModificationState> modifications = new ConcurrentSkipListMap();
    private final Collection<ModificationEvent> modificationEvents = new ArrayDeque<ModificationEvent>(1000);
    private final Map<String, TransactionPostProcess> postProcesses = new LinkedHashMap<String, TransactionPostProcess>();
    private final Set<String> alreadyPropagated = new LinkedHashSet<String>();
    private final Set<String> synchronizationKeys = new TreeSet<String>();

    public Set<String> getSynchronizationKeys() {
        return this.synchronizationKeys;
    }

    public int getSize() {
        return this.modifications.size();
    }

    public boolean doInnerCallbacks(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        long t0 = System.currentTimeMillis();
        boolean hasModifications = true;
        while (hasModifications) {
            hasModifications = false;
            for (GraphObjectModificationState state : this.modifications.values()) {
                if (!state.wasModified()) continue;
                if (!state.doInnerCallback(this, securityContext, errorBuffer)) {
                    return false;
                }
                hasModifications = true;
            }
        }
        long t = System.currentTimeMillis() - t0;
        if (t > 1000L) {
            logger.info("{} ms", (Object)t);
        }
        return true;
    }

    public boolean doValidation(SecurityContext securityContext, ErrorBuffer errorBuffer, boolean doValidation) throws FrameworkException {
        long t0 = System.currentTimeMillis();
        for (Map.Entry<String, GraphObjectModificationState> entry : this.modifications.entrySet()) {
            if (entry.getValue().doValidationAndIndexing(this, securityContext, errorBuffer, doValidation)) continue;
            return false;
        }
        long t = System.currentTimeMillis() - t0;
        if (t > 3000L) {
            logger.info("doValidation: {} ms", (Object)t);
        }
        return true;
    }

    public boolean doPostProcessing(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        for (TransactionPostProcess process : this.postProcesses.values()) {
            if (process.execute(securityContext, errorBuffer)) continue;
            return false;
        }
        return true;
    }

    public void doOuterCallbacks(SecurityContext securityContext) {
        long t0 = System.currentTimeMillis();
        for (GraphObjectModificationState state : this.modifications.values()) {
            state.doOuterCallback(securityContext);
        }
        long t = System.currentTimeMillis() - t0;
        if (t > 3000L) {
            logger.info("doOutCallbacks: {} ms", (Object)t);
        }
    }

    public void updateChangelog() {
        if (((Boolean)Settings.ChangelogEnabled.getValue()).booleanValue() && !this.modificationEvents.isEmpty()) {
            for (ModificationEvent ev : this.modificationEvents) {
                if (ev.isDeleted()) continue;
                try {
                    GraphObject obj = ev.getGraphObject();
                    if (obj == null) continue;
                    String existingLog = obj.getProperty(GraphObject.structrChangeLog);
                    String newLog = ev.getChangeLog();
                    String newValue = existingLog != null ? existingLog + newLog : newLog;
                    obj.unlockSystemPropertiesOnce();
                    obj.setProperty(GraphObject.structrChangeLog, newValue);
                }
                catch (Throwable t) {
                    logger.warn("", t);
                }
            }
        }
    }

    public void clear() {
        this.alreadyPropagated.clear();
        this.modifications.clear();
        this.modificationEvents.clear();
    }

    public void create(Principal user, NodeInterface node) {
        this.getState(node).create();
        if (((Boolean)Settings.ChangelogEnabled.getValue()).booleanValue() && user != null) {
            this.getState(user).updateChangeLog(user, GraphObjectModificationState.Verb.create, node.getUuid());
        }
    }

    public <S extends NodeInterface, T extends NodeInterface> void create(Principal user, RelationshipInterface relationship) {
        this.getState(relationship).create();
        NodeInterface sourceNode = relationship.getSourceNodeAsSuperUser();
        NodeInterface targetNode = relationship.getTargetNodeAsSuperUser();
        if (sourceNode != null && targetNode != null) {
            this.modifyEndNodes(user, sourceNode, targetNode, relationship.getRelType());
            this.getState(sourceNode).updateChangeLog(user, GraphObjectModificationState.Verb.link, relationship.getType(), relationship.getUuid(), targetNode.getUuid(), GraphObjectModificationState.Direction.out);
            this.getState(targetNode).updateChangeLog(user, GraphObjectModificationState.Verb.link, relationship.getType(), relationship.getUuid(), sourceNode.getUuid(), GraphObjectModificationState.Direction.in);
        }
    }

    public void modifyOwner(NodeInterface node) {
        this.getState(node).modifyOwner();
    }

    public void modifySecurity(NodeInterface node) {
        this.getState(node).modifySecurity();
    }

    public void modifyLocation(NodeInterface node) {
        this.getState(node).modifyLocation();
    }

    public void modify(Principal user, NodeInterface node, PropertyKey key, Object previousValue, Object newValue) {
        this.getState(node).modify(user, key, previousValue, newValue);
        if (key != null && key.requiresSynchronization()) {
            this.synchronizationKeys.add(key.getSynchronizationKey());
        }
    }

    public void modify(Principal user, RelationshipInterface relationship, PropertyKey key, Object previousValue, Object newValue) {
        this.getState(relationship).modify(user, key, previousValue, newValue);
        if (key != null && key.requiresSynchronization()) {
            this.synchronizationKeys.add(key.getSynchronizationKey());
        }
    }

    public void propagatedModification(NodeInterface node) {
        GraphObjectModificationState state;
        if (node != null && (state = this.getState(node, true)) != null) {
            state.propagatedModification();
            this.alreadyPropagated.add(this.hash(node));
        }
    }

    public void delete(Principal user, NodeInterface node) {
        Principal principal;
        SecurityContext securityContext;
        this.getState(node).delete(false);
        if (((Boolean)Settings.ChangelogEnabled.getValue()).booleanValue() && (securityContext = node.getSecurityContext()) != null && (principal = securityContext.getCachedUser()) != null) {
            this.getState(principal).updateChangeLog(user, GraphObjectModificationState.Verb.delete, node.getUuid());
        }
    }

    public void delete(Principal user, RelationshipInterface relationship, boolean passive) {
        this.getState(relationship).delete(passive);
        NodeInterface sourceNode = relationship.getSourceNodeAsSuperUser();
        NodeInterface targetNode = relationship.getTargetNodeAsSuperUser();
        this.modifyEndNodes(user, sourceNode, targetNode, relationship.getRelType());
        this.getState(sourceNode).updateChangeLog(user, GraphObjectModificationState.Verb.unlink, relationship.getType(), relationship.getUuid(), targetNode.getUuid(), GraphObjectModificationState.Direction.out);
        this.getState(targetNode).updateChangeLog(user, GraphObjectModificationState.Verb.unlink, relationship.getType(), relationship.getUuid(), sourceNode.getUuid(), GraphObjectModificationState.Direction.in);
    }

    public Collection<ModificationEvent> getModificationEvents() {
        return this.modificationEvents;
    }

    public void postProcess(String key, TransactionPostProcess process) {
        if (!this.postProcesses.containsKey(key)) {
            this.postProcesses.put(key, process);
        }
    }

    public boolean isDeleted(Node node) {
        GraphObjectModificationState state = this.modifications.get("N" + node.getId());
        if (state != null) {
            return state.isDeleted() || state.isPassivelyDeleted();
        }
        return false;
    }

    public boolean isDeleted(Relationship rel) {
        GraphObjectModificationState state = this.modifications.get("R" + rel.getId());
        if (state != null) {
            return state.isDeleted() || state.isPassivelyDeleted();
        }
        return false;
    }

    public void registerNodeCallback(NodeInterface node, String callbackId) {
        this.getState(node).setCallbackId(callbackId);
    }

    public void registerRelCallback(RelationshipInterface rel, String callbackId) {
        this.getState(rel).setCallbackId(callbackId);
    }

    public boolean isPropertyModified(GraphObject graphObject, PropertyKey key) {
        for (GraphObjectModificationState state : this.modifications.values()) {
            for (PropertyKey k : state.getModifiedProperties().keySet()) {
                if (!k.equals(key) || !graphObject.getUuid().equals(state.getGraphObject().getUuid())) continue;
                return true;
            }
        }
        return false;
    }

    public Set<PropertyKey> getModifiedProperties() {
        HashSet<PropertyKey> modifiedKeys = new HashSet<PropertyKey>();
        for (GraphObjectModificationState state : this.modifications.values()) {
            for (PropertyKey key : state.getModifiedProperties().keySet()) {
                if (modifiedKeys.contains(key)) continue;
                modifiedKeys.add(key);
            }
        }
        return modifiedKeys;
    }

    private void modifyEndNodes(Principal user, NodeInterface startNode, NodeInterface endNode, RelationshipType relType) {
        if (startNode != null && endNode != null) {
            if (RelType.OWNS.equals(relType)) {
                this.modifyOwner(startNode);
                this.modifyOwner(endNode);
                return;
            }
            if (RelType.SECURITY.equals(relType)) {
                this.modifySecurity(startNode);
                this.modifySecurity(endNode);
                return;
            }
            if (RelType.IS_AT.equals(relType)) {
                this.modifyLocation(startNode);
                this.modifyLocation(endNode);
                return;
            }
            this.modify(user, startNode, null, null, null);
            this.modify(user, endNode, null, null, null);
        }
    }

    private GraphObjectModificationState getState(NodeInterface node) {
        return this.getState(node, false);
    }

    private GraphObjectModificationState getState(NodeInterface node, boolean checkPropagation) {
        String hash = this.hash(node);
        GraphObjectModificationState state = this.modifications.get(hash);
        if (!(state != null || checkPropagation && this.alreadyPropagated.contains(hash))) {
            state = new GraphObjectModificationState(node);
            this.modifications.put(hash, state);
            this.modificationEvents.add(state);
        }
        return state;
    }

    private GraphObjectModificationState getState(RelationshipInterface rel) {
        return this.getState(rel, true);
    }

    private GraphObjectModificationState getState(RelationshipInterface rel, boolean create) {
        String hash = this.hash(rel);
        GraphObjectModificationState state = this.modifications.get(hash);
        if (state == null && create) {
            state = new GraphObjectModificationState(rel);
            this.modifications.put(hash, state);
            this.modificationEvents.add(state);
        }
        return state;
    }

    private String hash(NodeInterface node) {
        return "N" + node.getId();
    }

    private String hash(RelationshipInterface rel) {
        return "R" + rel.getId();
    }
}

