/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSemaphore {
    private static final Logger logger = LoggerFactory.getLogger((String)MultiSemaphore.class.getName());
    private final Map<String, Semaphore> semaphoreMap = new ConcurrentHashMap<String, Semaphore>();

    public synchronized void acquire(Set<String> types) throws InterruptedException {
        if (types != null && !types.isEmpty()) {
            for (Semaphore semaphore : this.getSemaphores(types)) {
                semaphore.acquire();
            }
        }
    }

    public void release(Set<String> types) {
        if (types != null && !types.isEmpty()) {
            for (Semaphore semaphore : this.getSemaphores(types)) {
                semaphore.release();
            }
        }
    }

    private Set<Semaphore> getSemaphores(Set<String> types) {
        LinkedHashSet<Semaphore> semaphores = new LinkedHashSet<Semaphore>();
        if (types != null) {
            for (String type : types) {
                if (type == null) continue;
                Semaphore semaphore = this.semaphoreMap.get(type);
                if (semaphore == null) {
                    semaphore = new Semaphore(1, true);
                    this.semaphoreMap.put(type, semaphore);
                }
                semaphores.add(semaphore);
            }
        }
        return semaphores;
    }
}

