/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.graph.Direction;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeServiceCommand;

public class NodeRelationshipStatisticsCommand
extends NodeServiceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)NodeRelationshipStatisticsCommand.class.getName());

    public Map<String, Long> execute(AbstractNode sNode) throws FrameworkException {
        return this.execute(sNode, null);
    }

    public Map<String, Long> execute(AbstractNode sNode, Direction dir) throws FrameworkException {
        LinkedHashMap<String, Long> statistics = new LinkedHashMap<String, Long>();
        Node node = sNode.getNode();
        Iterable rels = null;
        rels = dir != null ? node.getRelationships(dir) : node.getRelationships();
        try {
            LinkedHashMap<String, LongValueHolder> values = new LinkedHashMap<String, LongValueHolder>();
            for (Relationship relationship : rels) {
                String relType = relationship.getType().name();
                LongValueHolder count = (LongValueHolder)values.get(relType);
                if (count == null) {
                    count = new LongValueHolder();
                    values.put(relType, count);
                }
                count.inc();
            }
            for (Map.Entry entry : values.entrySet()) {
                String key = (String)entry.getKey();
                LongValueHolder value = (LongValueHolder)entry.getValue();
                statistics.put(key, value.getValue());
            }
        }
        catch (RuntimeException e) {
            logger.warn("Exception occured.", (Throwable)e);
        }
        return statistics;
    }

    private static class LongValueHolder {
        private long value = 0L;

        private LongValueHolder() {
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public void inc() {
            ++this.value;
        }
    }
}

