/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.graph.Direction;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.api.graph.RelationshipType;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.graph.RelationshipInterface;

public class NodeRelationshipsCommand
extends NodeServiceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)NodeRelationshipsCommand.class.getName());

    public List<RelationshipInterface> execute(NodeInterface sourceNode, RelationshipType relType, Direction dir) throws FrameworkException {
        RelationshipFactory factory = new RelationshipFactory(this.securityContext);
        LinkedList<RelationshipInterface> result = new LinkedList<RelationshipInterface>();
        Node node = sourceNode.getNode();
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        Iterable rels = relType != null ? node.getRelationships(dir, relType) : node.getRelationships(dir);
        try {
            for (Relationship r : rels) {
                result.add((RelationshipInterface)factory.instantiate(r));
            }
        }
        catch (RuntimeException e) {
            logger.warn("Exception occured: ", (Object)e.getMessage());
        }
        return result;
    }
}

