/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.graph.Relationship;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Factory;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.TransactionCommand;

public class RelationshipFactory<T extends RelationshipInterface>
extends Factory<Relationship, T> {
    private static final Logger logger = LoggerFactory.getLogger((String)RelationshipFactory.class.getName());

    public RelationshipFactory(SecurityContext securityContext) {
        super(securityContext);
    }

    public RelationshipFactory(SecurityContext securityContext, boolean includeDeletedAndHidden, boolean publicOnly) {
        super(securityContext, includeDeletedAndHidden, publicOnly);
    }

    public RelationshipFactory(SecurityContext securityContext, int pageSize, int page, String offsetId) {
        super(securityContext, pageSize, page, offsetId);
    }

    public RelationshipFactory(SecurityContext securityContext, boolean includeDeletedAndHidden, boolean publicOnly, int pageSize, int page, String offsetId) {
        super(securityContext, includeDeletedAndHidden, publicOnly, pageSize, page, offsetId);
    }

    @Override
    public T instantiate(Relationship relationship) {
        return this.instantiate(relationship, (Relationship)null);
    }

    @Override
    public T instantiate(Relationship relationship, Relationship pathSegment) {
        if (relationship == null || TransactionCommand.isDeleted(relationship)) {
            return null;
        }
        return this.instantiateWithType(relationship, (Class<T>)this.factoryDefinition.determineRelationshipType(relationship), (Relationship)null, false);
    }

    @Override
    public T instantiateWithType(Relationship relationship, Class<T> relClass, Relationship pathSegment, boolean isCreation) {
        String type;
        if (relClass == null) {
            return null;
        }
        logger.debug("Instantiate relationship with type {}", (Object)relClass.getName());
        SecurityContext securityContext = this.factoryProfile.getSecurityContext();
        RelationshipInterface newRel = null;
        try {
            newRel = (RelationshipInterface)relClass.newInstance();
        }
        catch (Throwable t) {
            logger.warn("", t);
            newRel = null;
        }
        if (newRel == null) {
            System.out.println("##################### newRel was null, using generic relationship..");
            newRel = StructrApp.getConfiguration().getFactoryDefinition().createGenericRelationship();
        }
        newRel.init(securityContext, relationship, relClass);
        if (!(isCreation || TransactionCommand.isDeleted(relationship) || (type = newRel.getProperty(GraphObject.type)) != null && (type == null || type.equals(relClass.getSimpleName())))) {
            try {
                newRel.unlockSystemPropertiesOnce();
                newRel.setProperty(GraphObject.type, relClass.getSimpleName());
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
        newRel.onRelationshipInstantiation();
        return (T)newRel;
    }

    @Override
    public T adapt(Relationship relationship) {
        return this.instantiate(relationship);
    }

    @Override
    public T instantiate(Relationship obj, boolean includeDeletedAndHidden, boolean publicOnly) throws FrameworkException {
        this.factoryProfile.setIncludeDeletedAndHidden(includeDeletedAndHidden);
        this.factoryProfile.setPublicOnly(publicOnly);
        return this.instantiate(obj);
    }

    @Override
    public T instantiateDummy(Relationship entity, String entityType) throws FrameworkException {
        Map<String, Class<? extends RelationshipInterface>> entities = StructrApp.getConfiguration().getRelationshipEntities();
        Class<? extends RelationshipInterface> relClass = entities.get(entityType);
        RelationshipInterface newRel = null;
        if (relClass != null) {
            try {
                newRel = relClass.newInstance();
                newRel.init(this.factoryProfile.getSecurityContext(), entity, relClass);
                newRel.onRelationshipInstantiation();
            }
            catch (Throwable t) {
                newRel = null;
            }
        }
        return (T)newRel;
    }
}

