/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.graph.Direction;
import org.structr.api.graph.Label;
import org.structr.api.graph.Node;
import org.structr.api.graph.PropertyContainer;
import org.structr.api.graph.Relationship;
import org.structr.api.graph.RelationshipType;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SuperUser;
import org.structr.core.graph.BulkCreateLabelsCommand;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeService;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.graph.Tx;
import org.structr.schema.SchemaHelper;

public class SyncCommand
extends NodeServiceCommand
implements MaintenanceCommand,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger((String)SyncCommand.class.getName());
    private static final String STRUCTR_ZIP_DB_NAME = "db";
    private static final Map<Class, Byte> typeMap = new HashMap<Class, Byte>();
    private static final Map<Byte, Class> classMap = new HashMap<Byte, Class>();

    @Override
    public void execute(Map<String, Object> attributes) throws FrameworkException {
        DatabaseService graphDb = Services.getInstance().getService(NodeService.class).getGraphDb();
        String mode = (String)attributes.get("mode");
        String fileName = (String)attributes.get("file");
        String validate = (String)attributes.get("validate");
        String query = (String)attributes.get("query");
        Long batchSize = (Long)attributes.get("batchSize");
        boolean doValidation = true;
        if (validate != null) {
            try {
                doValidation = Boolean.valueOf(validate);
            }
            catch (Throwable t) {
                logger.warn("Unable to parse value for validation flag: {}", (Object)t.getMessage());
            }
        }
        if (fileName == null) {
            throw new FrameworkException(400, "Please specify sync file.");
        }
        if ("export".equals(mode)) {
            SyncCommand.exportToFile(graphDb, fileName, query, true);
        } else if ("exportDb".equals(mode)) {
            SyncCommand.exportToFile(graphDb, fileName, query, false);
        } else if ("import".equals(mode)) {
            SyncCommand.importFromFile(graphDb, this.securityContext, fileName, doValidation, batchSize);
        } else {
            throw new FrameworkException(400, "Please specify sync mode (import|export).");
        }
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    @Override
    public boolean requiresFlushingOfCaches() {
        return false;
    }

    public static void exportToFile(DatabaseService graphDb, String fileName, String query, boolean includeFiles) throws FrameworkException {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            NodeFactory nodeFactory = new NodeFactory(SecurityContext.getSuperUserInstance());
            RelationshipFactory relFactory = new RelationshipFactory(SecurityContext.getSuperUserInstance());
            HashSet<AbstractNode> nodes = new HashSet<AbstractNode>();
            HashSet rels = new HashSet();
            boolean conditionalIncludeFiles = includeFiles;
            if (query != null) {
                logger.info("Using Cypher query {} to determine export set, disabling export of files", (Object)query);
                conditionalIncludeFiles = false;
                List<GraphObject> result = StructrApp.getInstance().cypher(query, null);
                for (GraphObject obj : result) {
                    if (obj.isNode()) {
                        nodes.add((AbstractNode)obj.getSyncNode());
                        continue;
                    }
                    rels.add((AbstractRelationship)obj.getSyncRelationship());
                }
                logger.info("Query returned {} nodes and {} relationships.", new Object[]{nodes.size(), rels.size()});
            } else {
                nodes.addAll(nodeFactory.bulkInstantiate(graphDb.getAllNodes()));
                rels.addAll(relFactory.bulkInstantiate(graphDb.getAllRelationships()));
            }
            FileOutputStream fos = new FileOutputStream(fileName);
            Object object = null;
            try {
                SyncCommand.exportToStream(fos, nodes, rels, null, conditionalIncludeFiles);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (fos != null) {
                    if (object != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        fos.close();
                    }
                }
            }
            tx.success();
        }
        catch (Throwable t) {
            logger.warn("", t);
            throw new FrameworkException(500, t.getMessage());
        }
    }

    public static void exportToFile(String fileName, Iterable<? extends NodeInterface> nodes, Iterable<? extends RelationshipInterface> relationships, Iterable<String> filePaths, boolean includeFiles) throws FrameworkException {
        try (Tx tx = StructrApp.getInstance().tx();){
            try (FileOutputStream fos = new FileOutputStream(fileName);){
                SyncCommand.exportToStream(fos, nodes, relationships, filePaths, includeFiles);
            }
            tx.success();
        }
        catch (Throwable t) {
            throw new FrameworkException(500, t.getMessage());
        }
    }

    public static void exportToStream(OutputStream outputStream, Iterable<? extends NodeInterface> nodes, Iterable<? extends RelationshipInterface> relationships, Iterable<String> filePaths, boolean includeFiles) throws FrameworkException {
        try (ZipOutputStream zos = new ZipOutputStream(outputStream);){
            LinkedHashSet<String> filesToInclude = new LinkedHashSet<String>();
            if (filePaths != null) {
                for (String file : filePaths) {
                    filesToInclude.add(file);
                }
            }
            zos.setLevel(6);
            if (includeFiles) {
                logger.info("Exporting files..");
                SyncCommand.exportDirectory(zos, new File("files"), "", filesToInclude.isEmpty() ? null : filesToInclude);
            }
            SyncCommand.exportDatabase(zos, new BufferedOutputStream(zos), nodes, relationships);
            zos.finish();
            zos.flush();
            zos.close();
        }
        catch (Throwable t) {
            logger.warn("", t);
            throw new FrameworkException(500, t.getMessage());
        }
    }

    public static void importFromFile(DatabaseService graphDb, SecurityContext securityContext, String fileName, boolean doValidation) throws FrameworkException {
        SyncCommand.importFromFile(graphDb, securityContext, fileName, doValidation, 400L);
    }

    public static void importFromFile(DatabaseService graphDb, SecurityContext securityContext, String fileName, boolean doValidation, Long batchSize) throws FrameworkException {
        try (FileInputStream fis = new FileInputStream(fileName);){
            SyncCommand.importFromStream(graphDb, securityContext, fis, doValidation, batchSize);
        }
        catch (Throwable t) {
            logger.warn("", t);
            throw new FrameworkException(500, t.getMessage());
        }
    }

    public static void importFromStream(DatabaseService graphDb, SecurityContext securityContext, InputStream inputStream, boolean doValidation, Long batchSize) throws FrameworkException {
        try (ZipInputStream zis = new ZipInputStream(inputStream);){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (STRUCTR_ZIP_DB_NAME.equals(entry.getName())) {
                    SyncCommand.importDatabase(graphDb, securityContext, zis, doValidation, batchSize);
                } else {
                    SyncCommand.importDirectory(zis, entry);
                }
                entry = zis.getNextEntry();
            }
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    public static void serializeData(DataOutputStream outputStream, byte[] data) throws IOException {
        outputStream.writeInt(data.length);
        outputStream.write(data);
        outputStream.flush();
    }

    public static void serialize(DataOutputStream outputStream, Object obj) throws IOException {
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            Byte type = typeMap.get(clazz);
            if (type != null) {
                if (clazz.isArray()) {
                    Object[] array = (Object[])obj;
                    outputStream.writeByte(type.byteValue());
                    outputStream.writeInt(array.length);
                    for (Object o : (Object[])obj) {
                        SyncCommand.serialize(outputStream, o);
                    }
                } else {
                    outputStream.writeByte(type.byteValue());
                    SyncCommand.writeObject(outputStream, type, obj);
                }
            } else {
                logger.warn("Unable to serialize object of type {}, type not supported", obj.getClass());
            }
        } else {
            outputStream.writeByte(127);
        }
        outputStream.flush();
    }

    public static byte[] deserializeData(DataInputStream inputStream) throws IOException {
        int len = inputStream.readInt();
        byte[] buffer = new byte[len];
        inputStream.read(buffer, 0, len);
        return buffer;
    }

    public static Object deserialize(DataInputStream inputStream) throws IOException {
        Object[] serializedObject = null;
        byte type = inputStream.readByte();
        Class clazz = classMap.get(type);
        if (clazz != null) {
            if (clazz.isArray()) {
                int len = inputStream.readInt();
                Object[] array = (Object[])Array.newInstance(clazz.getComponentType(), len);
                for (int i = 0; i < len; ++i) {
                    array[i] = SyncCommand.deserialize(inputStream);
                }
                serializedObject = array;
            } else {
                serializedObject = SyncCommand.readObject(inputStream, type);
            }
        } else if (type != 127) {
            logger.warn("Unsupported type \"{}\" in input", (Object)type);
        }
        return serializedObject;
    }

    private static void exportDirectory(ZipOutputStream zos, File dir, String path, Set<String> filesToInclude) throws IOException {
        String nestedPath = path + dir.getName() + "/";
        ZipEntry dirEntry = new ZipEntry(nestedPath);
        zos.putNextEntry(dirEntry);
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (File file : contents) {
                if (file.isDirectory()) {
                    SyncCommand.exportDirectory(zos, file, nestedPath, filesToInclude);
                    continue;
                }
                String fileName = file.getName();
                String relativePath = nestedPath + fileName;
                boolean includeFile = true;
                if (filesToInclude != null) {
                    includeFile = false;
                    if (filesToInclude.contains(fileName)) {
                        includeFile = true;
                    }
                }
                if (!includeFile) continue;
                ZipEntry fileEntry = new ZipEntry(relativePath);
                fileEntry.setTime(file.lastModified());
                zos.putNextEntry(fileEntry);
                FileInputStream fis = new FileInputStream(file);
                IOUtils.copy((InputStream)fis, (OutputStream)zos);
                fis.close();
                zos.flush();
                zos.closeEntry();
            }
        }
        zos.closeEntry();
    }

    private static void exportDatabase(ZipOutputStream zos, OutputStream outputStream, Iterable<? extends NodeInterface> nodes, Iterable<? extends RelationshipInterface> relationships) throws IOException, FrameworkException {
        ZipEntry dbEntry = new ZipEntry(STRUCTR_ZIP_DB_NAME);
        DataOutputStream dos = new DataOutputStream(outputStream);
        String uuidPropertyName = GraphObject.id.dbName();
        int nodeCount = 0;
        int relCount = 0;
        zos.putNextEntry(dbEntry);
        for (NodeInterface nodeInterface : nodes) {
            Node node = nodeInterface.getNode();
            if (!node.hasProperty(GraphObject.id.dbName())) continue;
            outputStream.write(78);
            for (String key : node.getPropertyKeys()) {
                SyncCommand.serialize(dos, key);
                SyncCommand.serialize(dos, node.getProperty(key));
            }
            dos.write(10);
            ++nodeCount;
        }
        dos.flush();
        for (RelationshipInterface relationshipInterface : relationships) {
            Relationship rel = relationshipInterface.getRelationship();
            if (!rel.hasProperty(GraphObject.id.dbName())) continue;
            Node startNode = rel.getStartNode();
            Node endNode = rel.getEndNode();
            if (!startNode.hasProperty(uuidPropertyName) || !endNode.hasProperty(uuidPropertyName)) continue;
            String startId = (String)startNode.getProperty(uuidPropertyName);
            String endId = (String)endNode.getProperty(uuidPropertyName);
            outputStream.write(82);
            SyncCommand.serialize(dos, startId);
            SyncCommand.serialize(dos, endId);
            SyncCommand.serialize(dos, rel.getType().name());
            for (String key : rel.getPropertyKeys()) {
                SyncCommand.serialize(dos, key);
                SyncCommand.serialize(dos, rel.getProperty(key));
            }
            dos.write(10);
            ++relCount;
        }
        dos.flush();
        zos.closeEntry();
        logger.info("Exported {} nodes and {} rels", new Object[]{nodeCount, relCount});
    }

    private static void importDirectory(ZipInputStream zis, ZipEntry entry) throws IOException {
        if (entry.isDirectory()) {
            File newDir = new File(entry.getName());
            if (!newDir.exists()) {
                newDir.mkdirs();
            }
        } else {
            File newFile = new File(entry.getName());
            boolean overwrite = false;
            if (!newFile.exists()) {
                overwrite = true;
            } else if (newFile.lastModified() < entry.getTime()) {
                logger.info("Overwriting existing file {} because import file is newer.", (Object)entry.getName());
                overwrite = true;
            }
            if (overwrite) {
                FileOutputStream fos = new FileOutputStream(newFile);
                IOUtils.copy((InputStream)zis, (OutputStream)fos);
                fos.flush();
                fos.close();
            }
        }
    }

    private static void importDatabase(DatabaseService graphDb, SecurityContext securityContext, ZipInputStream zis, boolean doValidation, Long batchSize) throws FrameworkException, IOException {
        Throwable throwable;
        Tx tx;
        App app = StructrApp.getInstance();
        DataInputStream dis = new DataInputStream(new BufferedInputStream(zis));
        RelationshipFactory relFactory = new RelationshipFactory(securityContext);
        long internalBatchSize = batchSize != null ? batchSize : 200L;
        NodeFactory nodeFactory = new NodeFactory(securityContext);
        String uuidPropertyName = GraphObject.id.dbName();
        LinkedHashMap<String, Node> uuidMap = new LinkedHashMap<String, Node>();
        HashSet<Long> deletedNodes = new HashSet<Long>();
        HashSet<Long> deletedRels = new HashSet<Long>();
        SuperUser superUser = new SuperUser();
        double t0 = System.nanoTime();
        Node currentObject = null;
        String currentKey = null;
        boolean finished = false;
        long totalNodeCount = 0L;
        long totalRelCount = 0L;
        do {
            tx = app.tx(doValidation);
            throwable = null;
            try {
                Object entity;
                LinkedList<Relationship> rels = new LinkedList<Relationship>();
                LinkedList<Node> nodes = new LinkedList<Node>();
                long nodeCount = 0L;
                long relCount = 0L;
                do {
                    try {
                        dis.mark(4);
                        byte objectType = dis.readByte();
                        if (objectType == 10) continue;
                        if (objectType == 78) {
                            if (nodeCount + relCount >= internalBatchSize) {
                                dis.reset();
                                break;
                            }
                            currentObject = graphDb.createNode(Collections.EMPTY_SET, Collections.EMPTY_MAP);
                            ++nodeCount;
                            nodes.add(currentObject);
                            continue;
                        }
                        if (objectType == 82) {
                            if (nodeCount + relCount >= internalBatchSize) {
                                dis.reset();
                                break;
                            }
                            String startId = (String)SyncCommand.deserialize(dis);
                            String endId = (String)SyncCommand.deserialize(dis);
                            String relTypeName = (String)SyncCommand.deserialize(dis);
                            Node endNode = (Node)uuidMap.get(endId);
                            Node startNode = (Node)uuidMap.get(startId);
                            if (startNode != null && endNode != null) {
                                if (deletedNodes.contains(startNode.getId()) || deletedNodes.contains(endNode.getId())) {
                                    System.out.println("NOT creating relationship between deleted nodes..");
                                    currentObject = null;
                                    currentKey = null;
                                    continue;
                                }
                                RelationshipType relType = RelationshipType.forName((String)relTypeName);
                                currentObject = startNode.createRelationshipTo(endNode, relType);
                                rels.add((Relationship)currentObject);
                                ++relCount;
                                continue;
                            }
                            System.out.println("NOT creating relationship of type " + relTypeName + ", start: " + startId + ", end: " + endId);
                            currentObject = null;
                            currentKey = null;
                            continue;
                        }
                        dis.reset();
                        if (currentKey == null) {
                            try {
                                currentKey = (String)SyncCommand.deserialize(dis);
                            }
                            catch (Throwable t) {
                                logger.warn("", t);
                            }
                            continue;
                        }
                        Object obj = SyncCommand.deserialize(dis);
                        if (obj != null && currentObject != null) {
                            if (uuidPropertyName.equals(currentKey) && currentObject instanceof Node) {
                                String uuid = (String)obj;
                                uuidMap.put(uuid, currentObject);
                            }
                            if (currentKey.length() != 0) {
                                currentObject.setProperty(currentKey, obj);
                                if (currentObject instanceof Node && NodeInterface.type.dbName().equals(currentKey)) {
                                    currentObject.addLabel((Label)graphDb.forName(Label.class, (String)obj));
                                }
                            } else {
                                logger.error("Invalid property key for value {}, ignoring", obj);
                            }
                        } else {
                            logger.warn("No current object to store property in.");
                        }
                        currentKey = null;
                    }
                    catch (EOFException eofex) {
                        finished = true;
                    }
                } while (!finished);
                totalNodeCount += nodeCount;
                totalRelCount += relCount;
                for (Node node : nodes) {
                    if (deletedNodes.contains(node.getId())) continue;
                    entity = nodeFactory.instantiate(node);
                    if (entity instanceof AbstractSchemaNode) {
                        SyncCommand.checkAndMerge(entity, deletedNodes, deletedRels);
                    }
                    if (deletedNodes.contains(node.getId())) continue;
                    TransactionCommand.nodeCreated(superUser, entity);
                    entity.addToIndex();
                }
                for (Relationship rel : rels) {
                    if (deletedRels.contains(rel.getId())) continue;
                    entity = relFactory.instantiate(rel);
                    TransactionCommand.relationshipCreated(superUser, entity);
                    entity.addToIndex();
                }
                logger.info("Imported {} nodes and {} rels, committing transaction..", new Object[]{totalNodeCount, totalRelCount});
                tx.success();
            }
            catch (Throwable rels) {
                throwable = rels;
                throw rels;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable rels) {
                            throwable.addSuppressed(rels);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        } while (!finished);
        try {
            tx = app.tx();
            throwable = null;
            try {
                SchemaHelper.reloadSchema(new ErrorBuffer(), securityContext.getSessionId());
                tx.success();
            }
            catch (Throwable rels) {
                throwable = rels;
                throw rels;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable rels) {
                            throwable.addSuppressed(rels);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        app.command(BulkCreateLabelsCommand.class).execute(Collections.emptyMap());
        double t1 = System.nanoTime();
        double time = (t1 - t0) / 1.0E9;
        DecimalFormat decimalFormat = new DecimalFormat("0.000000000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        logger.info("Import done in {} s", (Object)decimalFormat.format(time));
    }

    private static Object readObject(DataInputStream inputStream, byte type) throws IOException {
        switch (type) {
            case 0: 
            case 1: {
                return inputStream.readByte();
            }
            case 2: 
            case 3: {
                return inputStream.readShort();
            }
            case 4: 
            case 5: {
                return inputStream.readInt();
            }
            case 6: 
            case 7: {
                return inputStream.readLong();
            }
            case 8: 
            case 9: {
                return Float.valueOf(inputStream.readFloat());
            }
            case 10: 
            case 11: {
                return inputStream.readDouble();
            }
            case 12: 
            case 13: {
                return Character.valueOf(inputStream.readChar());
            }
            case 14: 
            case 15: {
                return new String(SyncCommand.deserializeData(inputStream), "UTF-8");
            }
            case 16: 
            case 17: {
                return inputStream.readBoolean();
            }
        }
        return null;
    }

    private static void writeObject(DataOutputStream outputStream, byte type, Object value) throws IOException {
        switch (type) {
            case 0: 
            case 1: {
                outputStream.writeByte(((Byte)value).byteValue());
                break;
            }
            case 2: 
            case 3: {
                outputStream.writeShort(((Short)value).shortValue());
                break;
            }
            case 4: 
            case 5: {
                outputStream.writeInt((Integer)value);
                break;
            }
            case 6: 
            case 7: {
                outputStream.writeLong((Long)value);
                break;
            }
            case 8: 
            case 9: {
                outputStream.writeFloat(((Float)value).floatValue());
                break;
            }
            case 10: 
            case 11: {
                outputStream.writeDouble((Double)value);
                break;
            }
            case 12: 
            case 13: {
                outputStream.writeChar(((Character)value).charValue());
                break;
            }
            case 14: 
            case 15: {
                SyncCommand.serializeData(outputStream, ((String)value).getBytes("UTF-8"));
                break;
            }
            case 16: 
            case 17: {
                outputStream.writeBoolean((Boolean)value);
            }
        }
    }

    private static boolean checkAndMerge(NodeInterface node, Set<Long> deletedNodes, Set<Long> deletedRels) throws FrameworkException {
        Class<?> type = node.getClass();
        String name = node.getName();
        List<?> existingNodes = StructrApp.getInstance().nodeQuery(type).andName(name).getAsList();
        for (NodeInterface existingNode : existingNodes) {
            Relationship newRel;
            Node otherNode;
            Node sourceNode = node.getNode();
            Node targetNode = existingNode.getNode();
            if (sourceNode.getId() == targetNode.getId()) continue;
            logger.info("Found existing schema node {}, merging!", (Object)name);
            SyncCommand.copyProperties((PropertyContainer)sourceNode, (PropertyContainer)targetNode);
            for (Relationship outRel : sourceNode.getRelationships(Direction.OUTGOING)) {
                otherNode = outRel.getEndNode();
                newRel = targetNode.createRelationshipTo(otherNode, outRel.getType());
                SyncCommand.copyProperties((PropertyContainer)outRel, (PropertyContainer)newRel);
                deletedRels.add(outRel.getId());
                outRel.delete();
                System.out.println("############################################ Deleting relationship " + outRel.getId());
            }
            for (Relationship inRel : sourceNode.getRelationships(Direction.INCOMING)) {
                otherNode = inRel.getStartNode();
                newRel = otherNode.createRelationshipTo(targetNode, inRel.getType());
                SyncCommand.copyProperties((PropertyContainer)inRel, (PropertyContainer)newRel);
                deletedRels.add(inRel.getId());
                inRel.delete();
                System.out.println("############################################ Deleting relationship " + inRel.getId());
            }
            Map<String, List<Node>> groupedNodes = SyncCommand.groupByTypeAndName(Iterables.toList((Iterable)Iterables.map((Function)new EndNodes(), (Iterable)targetNode.getRelationships(Direction.OUTGOING))));
            for (List<Node> nodes : groupedNodes.values()) {
                int size = nodes.size();
                if (size <= 1) continue;
                Node groupTargetNode = nodes.get(0);
                for (Node groupSourceNode : nodes.subList(1, size)) {
                    SyncCommand.copyProperties((PropertyContainer)groupSourceNode, (PropertyContainer)groupTargetNode);
                    for (Relationship groupRel : groupSourceNode.getRelationships()) {
                        deletedRels.add(groupRel.getId());
                        groupRel.delete();
                    }
                    deletedNodes.add(groupSourceNode.getId());
                    groupSourceNode.delete();
                    System.out.println("############################################ Deleting node " + groupSourceNode.getId());
                }
            }
            deletedNodes.add(sourceNode.getId());
            sourceNode.delete();
            System.out.println("############################################ Deleting node " + sourceNode.getId());
            return true;
        }
        return false;
    }

    private static void copyProperties(PropertyContainer source, PropertyContainer target) {
        for (String key : source.getPropertyKeys()) {
            if ("id".equals(key)) continue;
            target.setProperty(key, source.getProperty(key));
        }
    }

    private static Map<String, List<Node>> groupByTypeAndName(Iterable<Node> nodes) {
        LinkedHashMap<String, List<Node>> groupedNodes = new LinkedHashMap<String, List<Node>>();
        for (Node node : nodes) {
            if (!node.hasProperty("name") || !node.hasProperty("type")) continue;
            String typeAndName = node.getProperty("type") + "." + node.getProperty("name");
            LinkedList<Node> nodeList = (LinkedList<Node>)groupedNodes.get(typeAndName);
            if (nodeList == null) {
                nodeList = new LinkedList<Node>();
                groupedNodes.put(typeAndName, nodeList);
            }
            nodeList.add(node);
        }
        return groupedNodes;
    }

    static {
        typeMap.put(Byte[].class, (byte)0);
        typeMap.put(Byte.class, (byte)1);
        typeMap.put(Short[].class, (byte)2);
        typeMap.put(Short.class, (byte)3);
        typeMap.put(Integer[].class, (byte)4);
        typeMap.put(Integer.class, (byte)5);
        typeMap.put(Long[].class, (byte)6);
        typeMap.put(Long.class, (byte)7);
        typeMap.put(Float[].class, (byte)8);
        typeMap.put(Float.class, (byte)9);
        typeMap.put(Double[].class, (byte)10);
        typeMap.put(Double.class, (byte)11);
        typeMap.put(Character[].class, (byte)12);
        typeMap.put(Character.class, (byte)13);
        typeMap.put(String[].class, (byte)14);
        typeMap.put(String.class, (byte)15);
        typeMap.put(Boolean[].class, (byte)16);
        typeMap.put(Boolean.class, (byte)17);
        for (Map.Entry<Class, Byte> entry : typeMap.entrySet()) {
            classMap.put(entry.getValue(), entry.getKey());
        }
    }

    private static class EndNodes
    implements Function<Relationship, Node> {
        private EndNodes() {
        }

        @Override
        public Node apply(Relationship from) throws RuntimeException {
            return from.getEndNode();
        }
    }
}

