/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.NotInTransactionException;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.StructrTransactionListener;
import org.structr.core.TransactionSource;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.core.graph.ModificationEvent;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.MultiSemaphore;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.TransactionPostProcess;
import org.structr.core.graph.TransactionReference;
import org.structr.core.property.PropertyKey;

public class TransactionCommand
extends NodeServiceCommand
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger((String)TransactionCommand.class.getName());
    private static final Set<StructrTransactionListener> listeners = new LinkedHashSet<StructrTransactionListener>();
    private static final ThreadLocal<ModificationQueue> queues = new ThreadLocal();
    private static final ThreadLocal<ErrorBuffer> buffers = new ThreadLocal();
    private static final ThreadLocal<TransactionCommand> currentCommand = new ThreadLocal();
    private static final ThreadLocal<TransactionReference> transactions = new ThreadLocal();
    private static final MultiSemaphore semaphore = new MultiSemaphore();

    public TransactionCommand beginTx() {
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        TransactionReference tx = transactions.get();
        if (graphDb != null) {
            if (tx == null) {
                tx = new TransactionReference(graphDb.beginTx());
                queues.set(new ModificationQueue());
                buffers.set(new ErrorBuffer());
                transactions.set(tx);
                currentCommand.set(this);
            }
            tx.begin();
        }
        return this;
    }

    public void commitTx(boolean doValidation) throws FrameworkException {
        TransactionReference tx = transactions.get();
        if (tx != null && tx.isToplevel()) {
            ModificationQueue modificationQueue = queues.get();
            ErrorBuffer errorBuffer = buffers.get();
            for (StructrTransactionListener listener : listeners) {
                listener.beforeCommit(this.securityContext, modificationQueue.getModificationEvents(), tx.getSource());
            }
            if (!modificationQueue.doInnerCallbacks(this.securityContext, errorBuffer)) {
                tx.failure();
                throw new FrameworkException(422, "Unable to commit transaction, validation failed", errorBuffer);
            }
            Set<String> synchronizationKeys = modificationQueue.getSynchronizationKeys();
            try {
                semaphore.acquire(synchronizationKeys);
            }
            catch (InterruptedException iex) {
                return;
            }
            if (doValidation && !modificationQueue.doValidation(this.securityContext, errorBuffer, doValidation)) {
                tx.failure();
                throw new FrameworkException(422, "Unable to commit transaction, validation failed", errorBuffer);
            }
            if (!modificationQueue.doPostProcessing(this.securityContext, errorBuffer)) {
                tx.failure();
                throw new FrameworkException(422, "Unable to commit transaction, transaction post processing failed", errorBuffer);
            }
            try {
                tx.success();
            }
            catch (Throwable t) {
                logger.error("Unable to commit transaction", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModificationQueue finishTx() {
        TransactionReference tx = transactions.get();
        ModificationQueue modificationQueue = null;
        if (tx != null) {
            if (tx.isToplevel()) {
                modificationQueue = queues.get();
                Set<String> synchronizationKeys = modificationQueue.getSynchronizationKeys();
                queues.remove();
                buffers.remove();
                currentCommand.remove();
                transactions.remove();
                try {
                    tx.close();
                }
                finally {
                    semaphore.release(synchronizationKeys);
                }
            } else {
                tx.end();
            }
        }
        return modificationQueue;
    }

    @Override
    public void close() throws FrameworkException {
        this.finishTx();
    }

    public Collection<ModificationEvent> getModificationEvents() {
        ModificationQueue modificationQueue = queues.get();
        if (modificationQueue != null) {
            return modificationQueue.getModificationEvents();
        }
        return null;
    }

    public void setSource(TransactionSource source) {
        TransactionReference tx = transactions.get();
        if (tx != null) {
            tx.setSource(source);
        }
    }

    public TransactionSource getSource() {
        TransactionReference tx = transactions.get();
        if (tx != null) {
            return tx.getSource();
        }
        return null;
    }

    public static void postProcess(String key, TransactionPostProcess process) {
        TransactionCommand command = currentCommand.get();
        if (command != null) {
            ModificationQueue modificationQueue = command.getModificationQueue();
            if (modificationQueue != null) {
                modificationQueue.postProcess(key, process);
            } else {
                logger.error("Got empty changeSet from command!");
            }
        } else {
            logger.error("Trying to register transaction post processing while outside of transaction!");
        }
    }

    public static void nodeCreated(Principal user, NodeInterface node) {
        TransactionCommand command = currentCommand.get();
        if (command != null) {
            ModificationQueue modificationQueue = command.getModificationQueue();
            if (modificationQueue != null) {
                modificationQueue.create(user, node);
            } else {
                logger.error("Got empty changeSet from command!");
            }
        } else {
            logger.error("Node created while outside of transaction!");
        }
    }

    public static void nodeModified(Principal user, AbstractNode node, PropertyKey key, Object previousValue, Object newValue) {
        TransactionCommand command = currentCommand.get();
        if (command != null) {
            ModificationQueue modificationQueue = command.getModificationQueue();
            if (modificationQueue != null) {
                modificationQueue.modify(user, node, key, previousValue, newValue);
            } else {
                logger.error("Got empty changeSet from command!");
            }
        } else {
            logger.error("Node deleted while outside of transaction!");
        }
    }

    public static void nodeDeleted(Principal user, NodeInterface node) {
        TransactionCommand command = currentCommand.get();
        if (command != null) {
            ModificationQueue modificationQueue = command.getModificationQueue();
            if (modificationQueue != null) {
                modificationQueue.delete(user, node);
            } else {
                logger.error("Got empty changeSet from command!");
            }
        } else {
            logger.error("Node deleted while outside of transaction!");
        }
    }

    public static void relationshipCreated(Principal user, RelationshipInterface relationship) {
        TransactionCommand command = currentCommand.get();
        if (command != null) {
            ModificationQueue modificationQueue = command.getModificationQueue();
            if (modificationQueue != null) {
                modificationQueue.create(user, relationship);
            } else {
                logger.error("Got empty changeSet from command!");
            }
        } else {
            logger.error("Relationships created while outside of transaction!");
        }
    }

    public static void relationshipModified(Principal user, RelationshipInterface relationship, PropertyKey key, Object previousValue, Object newValue) {
        TransactionCommand command = currentCommand.get();
        if (command != null) {
            ModificationQueue modificationQueue = command.getModificationQueue();
            if (modificationQueue != null) {
                modificationQueue.modify(user, relationship, key, previousValue, newValue);
            } else {
                logger.error("Got empty changeSet from command!");
            }
        } else {
            logger.error("Relationship deleted while outside of transaction!");
        }
    }

    public static void relationshipDeleted(Principal user, RelationshipInterface relationship, boolean passive) {
        TransactionCommand command = currentCommand.get();
        if (command != null) {
            ModificationQueue modificationQueue = command.getModificationQueue();
            if (modificationQueue != null) {
                modificationQueue.delete(user, relationship, passive);
            } else {
                logger.error("Got empty changeSet from command!");
            }
        } else {
            logger.error("Relationship deleted while outside of transaction!");
        }
    }

    public static void registerTransactionListener(StructrTransactionListener listener) {
        listeners.add(listener);
    }

    public static void removeTransactionListener(StructrTransactionListener listener) {
        listeners.remove(listener);
    }

    public static Set<StructrTransactionListener> getTransactionListeners() {
        return listeners;
    }

    public static void simpleBroadcast(String messageName, Map<String, Object> data) {
        TransactionCommand.simpleBroadcast(messageName, data, null);
    }

    public static void simpleBroadcast(String messageName, Map<String, Object> data, String exemptedSessionId) {
        for (StructrTransactionListener listener : TransactionCommand.getTransactionListeners()) {
            listener.simpleBroadcast(messageName, data, exemptedSessionId);
        }
    }

    public static boolean inTransaction() {
        return currentCommand.get() != null;
    }

    public static boolean isDeleted(Node node) {
        if (!TransactionCommand.inTransaction()) {
            throw new NotInTransactionException("Not in transaction.");
        }
        ModificationQueue queue = queues.get();
        if (queue != null) {
            return queue.isDeleted(node);
        }
        return false;
    }

    public static boolean isDeleted(Relationship rel) {
        if (!TransactionCommand.inTransaction()) {
            throw new NotInTransactionException("Not in transaction.");
        }
        ModificationQueue queue = queues.get();
        if (queue != null) {
            return queue.isDeleted(rel);
        }
        return false;
    }

    public static void registerNodeCallback(NodeInterface node, String callbackId) {
        TransactionCommand command = currentCommand.get();
        if (command != null) {
            ModificationQueue modificationQueue = command.getModificationQueue();
            if (modificationQueue != null) {
                modificationQueue.registerNodeCallback(node, callbackId);
            } else {
                logger.error("Got empty changeSet from command!");
            }
        } else {
            logger.error("Unable to register node callback");
        }
    }

    public static void registerRelCallback(RelationshipInterface rel, String callbackId) {
        TransactionCommand command = currentCommand.get();
        if (command != null) {
            ModificationQueue modificationQueue = command.getModificationQueue();
            if (modificationQueue != null) {
                modificationQueue.registerRelCallback(rel, callbackId);
            } else {
                logger.error("Got empty changeSet from command!");
            }
        } else {
            logger.error("Unable to register relationship callback");
        }
    }

    private ModificationQueue getModificationQueue() {
        return queues.get();
    }
}

