/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph.search;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.structr.api.search.EmptyQuery;
import org.structr.api.search.Occurrence;
import org.structr.core.GraphObject;
import org.structr.core.graph.search.PropertySearchAttribute;
import org.structr.core.property.PropertyKey;

public class EmptySearchAttribute<T>
extends PropertySearchAttribute<T> {
    public EmptySearchAttribute(PropertyKey<T> key, T value) {
        super(key, value, Occurrence.REQUIRED, true);
    }

    @Override
    public String toString() {
        return "EmptySearchAttribute()";
    }

    @Override
    public Class getQueryType() {
        return EmptyQuery.class;
    }

    @Override
    public boolean includeInResult(GraphObject entity) {
        Occurrence occur = this.getOccurrence();
        Object searchValue = this.getValue();
        Object nodeValue = entity.getProperty(this.getKey());
        return !(occur.equals((Object)Occurrence.FORBIDDEN) ? nodeValue != null && !this.equal(nodeValue, searchValue) : (nodeValue != null ? !this.equal(nodeValue, searchValue) : searchValue != null));
    }

    private boolean equal(T nodeValue, T searchValue) {
        if (nodeValue == null && searchValue == null) {
            return true;
        }
        if (nodeValue == null && searchValue != null) {
            return false;
        }
        if (nodeValue != null && searchValue == null) {
            if (nodeValue instanceof Collection) {
                return this.isEmptyOrValue((Collection)nodeValue);
            }
            return StringUtils.isBlank((CharSequence)nodeValue.toString());
        }
        if (nodeValue instanceof Collection && searchValue instanceof Collection) {
            Collection nodeCollection = (Collection)nodeValue;
            Collection searchCollection = (Collection)searchValue;
            if (nodeCollection.isEmpty() && searchCollection.isEmpty()) {
                return true;
            }
            if (this.isEmptyOrValue(nodeCollection) && searchCollection.isEmpty()) {
                return true;
            }
            if (nodeCollection.isEmpty() && this.isEmptyOrValue(searchCollection)) {
                return true;
            }
        }
        return false;
    }

    private boolean isEmptyOrValue(Collection<T> collection) {
        if (collection == null) {
            return true;
        }
        if (collection.isEmpty()) {
            return true;
        }
        for (T t : collection) {
            if (t == null) continue;
            return false;
        }
        return true;
    }
}

