/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph.search;

import org.apache.commons.lang3.StringUtils;
import org.structr.api.search.ExactQuery;
import org.structr.api.search.FulltextQuery;
import org.structr.api.search.Occurrence;
import org.structr.core.GraphObject;
import org.structr.core.graph.search.SearchAttribute;
import org.structr.core.property.PropertyKey;

public class PropertySearchAttribute<T>
extends SearchAttribute<T>
implements ExactQuery,
FulltextQuery {
    private boolean isExactMatch = false;

    public PropertySearchAttribute(PropertyKey<T> key, T value, Occurrence occur, boolean isExactMatch) {
        super(occur, key, value);
        this.isExactMatch = isExactMatch;
    }

    @Override
    public String toString() {
        return "PropertySearchAttribute(" + super.toString() + ")";
    }

    public Class getQueryType() {
        return this.isExactMatch ? ExactQuery.class : FulltextQuery.class;
    }

    public boolean isExactMatch() {
        return this.isExactMatch;
    }

    @Override
    public void setExactMatch(boolean exact) {
        this.isExactMatch = exact;
    }

    @Override
    public boolean includeInResult(GraphObject entity) {
        Object nodeValue = entity.getProperty(this.getKey());
        Occurrence occur = this.getOccurrence();
        Object searchValue = this.getValue();
        if (occur.equals((Object)Occurrence.FORBIDDEN)) {
            if (nodeValue != null && this.compare(nodeValue, searchValue) == 0) {
                return false;
            }
        } else if (nodeValue != null) {
            if (!this.isExactMatch && nodeValue instanceof String && searchValue instanceof String) {
                String n = (String)nodeValue;
                String s = (String)searchValue;
                return StringUtils.containsIgnoreCase((CharSequence)n, (CharSequence)s);
            }
            if (this.compare(nodeValue, searchValue) != 0) {
                return false;
            }
        } else if (searchValue != null && StringUtils.isNotBlank((CharSequence)searchValue.toString())) {
            return false;
        }
        return true;
    }

    private int compare(T nodeValue, T searchValue) {
        if (nodeValue instanceof Comparable && searchValue instanceof Comparable) {
            Comparable n = (Comparable)nodeValue;
            Comparable s = (Comparable)searchValue;
            return n.compareTo(s);
        }
        return 0;
    }
}

