/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph.search;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.structr.api.search.GroupQuery;
import org.structr.api.search.Occurrence;
import org.structr.api.search.QueryPredicate;
import org.structr.core.GraphObject;
import org.structr.core.graph.search.SearchAttribute;

public class SearchAttributeGroup
extends SearchAttribute
implements GroupQuery {
    private List<SearchAttribute> searchItems = new LinkedList<SearchAttribute>();
    private SearchAttributeGroup parent = null;

    public SearchAttributeGroup(Occurrence occur) {
        this((SearchAttributeGroup)null, occur);
    }

    public SearchAttributeGroup(SearchAttributeGroup parent, Occurrence occur) {
        super(occur);
        this.parent = parent;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("SearchAttributeGroup(");
        Iterator<SearchAttribute> it = this.searchItems.iterator();
        while (it.hasNext()) {
            SearchAttribute item = it.next();
            buf.append(item.toString());
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    public final SearchAttributeGroup getParent() {
        return this.parent;
    }

    public final void setSearchAttributes(List<SearchAttribute> searchItems) {
        this.searchItems = searchItems;
    }

    public List<SearchAttribute> getSearchAttributes() {
        return this.searchItems;
    }

    public void add(SearchAttribute searchAttribute) {
        this.searchItems.add(searchAttribute);
    }

    public boolean isExactMatch() {
        boolean exactMatch = true;
        for (SearchAttribute attr : this.getSearchAttributes()) {
            exactMatch &= attr.isExactMatch();
        }
        return exactMatch;
    }

    @Override
    public boolean includeInResult(GraphObject entity) {
        boolean includeInResult = true;
        for (SearchAttribute attr : this.getSearchAttributes()) {
            switch (attr.getOccurrence()) {
                case REQUIRED: {
                    includeInResult &= attr.includeInResult(entity);
                    break;
                }
                case OPTIONAL: {
                    if (attr.includeInResult(entity)) {
                        return true;
                    }
                    includeInResult = false;
                    break;
                }
                case FORBIDDEN: {
                    includeInResult &= !attr.includeInResult(entity);
                }
            }
        }
        return includeInResult;
    }

    @Override
    public void setExactMatch(boolean exact) {
        for (SearchAttribute attr : this.getSearchAttributes()) {
            attr.setExactMatch(exact);
        }
    }

    public Class getQueryType() {
        return GroupQuery.class;
    }

    public List<QueryPredicate> getQueryPredicates() {
        LinkedList<QueryPredicate> predicates = new LinkedList<QueryPredicate>();
        for (SearchAttribute attr : this.searchItems) {
            predicates.add(attr);
        }
        return predicates;
    }
}

