/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.graph.PropertyContainer;
import org.structr.api.index.Index;
import org.structr.api.search.Occurrence;
import org.structr.api.search.QueryPredicate;
import org.structr.common.GraphObjectComparator;
import org.structr.common.PagingHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.geo.GeoCodingResult;
import org.structr.common.geo.GeoHelper;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.Factory;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.search.DistanceSearchAttribute;
import org.structr.core.graph.search.EmptySearchAttribute;
import org.structr.core.graph.search.NotBlankSearchAttribute;
import org.structr.core.graph.search.PropertySearchAttribute;
import org.structr.core.graph.search.RangeSearchAttribute;
import org.structr.core.graph.search.SearchAttribute;
import org.structr.core.graph.search.SearchAttributeGroup;
import org.structr.core.graph.search.SourceSearchAttribute;
import org.structr.core.graph.search.TypeSearchAttribute;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.schema.ConfigurationProvider;

public abstract class SearchCommand<S extends PropertyContainer, T extends GraphObject>
extends NodeServiceCommand
implements Query<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)SearchCommand.class.getName());
    protected static final boolean INCLUDE_DELETED_AND_HIDDEN = true;
    protected static final boolean PUBLIC_ONLY = false;
    private static final Map<String, Set<String>> subtypeMapForType = new LinkedHashMap<String, Set<String>>();
    private static final Set<String> baseTypes = new LinkedHashSet<String>();
    public static final String LAT_LON_SEARCH_KEYWORD = "latlon";
    public static final String LOCATION_SEARCH_KEYWORD = "location";
    public static final String STATE_SEARCH_KEYWORD = "state";
    public static final String HOUSE_SEARCH_KEYWORD = "house";
    public static final String COUNTRY_SEARCH_KEYWORD = "country";
    public static final String POSTAL_CODE_SEARCH_KEYWORD = "postalCode";
    public static final String DISTANCE_SEARCH_KEYWORD = "distance";
    public static final String CITY_SEARCH_KEYWORD = "city";
    public static final String STREET_SEARCH_KEYWORD = "street";
    private final SearchAttributeGroup rootGroup;
    private SearchAttributeGroup currentGroup;
    private PropertyKey sortKey;
    private boolean publicOnly;
    private boolean includeDeletedAndHidden;
    private boolean sortDescending;
    private boolean doNotSort;
    private String offsetId;
    private int pageSize;
    private int page;

    public SearchCommand() {
        this.currentGroup = this.rootGroup = new SearchAttributeGroup(Occurrence.REQUIRED);
        this.sortKey = null;
        this.publicOnly = false;
        this.includeDeletedAndHidden = true;
        this.sortDescending = false;
        this.doNotSort = false;
        this.offsetId = null;
        this.pageSize = Integer.MAX_VALUE;
        this.page = 1;
    }

    public abstract Factory<S, T> getFactory(SecurityContext var1, boolean var2, boolean var3, int var4, int var5, String var6);

    public abstract boolean isRelationshipSearch();

    public abstract Index<S> getIndex();

    private Result<T> doSearch() throws FrameworkException {
        if (this.page == 0 || this.pageSize <= 0) {
            return Result.EMPTY_RESULT;
        }
        Factory<S, T> factory = this.getFactory(this.securityContext, this.includeDeletedAndHidden, this.publicOnly, this.pageSize, this.page, this.offsetId);
        boolean hasGraphSources = false;
        boolean hasSpatialSource = false;
        if (this.securityContext.getUser(false) == null) {
            this.rootGroup.add(new PropertySearchAttribute<Boolean>(GraphObject.visibleToPublicUsers, true, Occurrence.REQUIRED, true));
        }
        if (!this.includeDeletedAndHidden && !this.isRelationshipSearch()) {
            this.rootGroup.add(new PropertySearchAttribute<Boolean>(NodeInterface.hidden, true, Occurrence.FORBIDDEN, true));
            this.rootGroup.add(new PropertySearchAttribute<Boolean>(NodeInterface.deleted, true, Occurrence.FORBIDDEN, true));
        }
        ArrayList<SourceSearchAttribute> sources = new ArrayList<SourceSearchAttribute>();
        boolean hasEmptySearchFields = false;
        Result intermediateResult = null;
        for (SearchAttribute attr : this.rootGroup.getSearchAttributes()) {
            if (attr instanceof SearchAttributeGroup) {
                Iterator<SearchAttribute> groupIterator = ((SearchAttributeGroup)attr).getSearchAttributes().iterator();
                while (groupIterator.hasNext()) {
                    SearchAttribute item = groupIterator.next();
                    if (item instanceof SourceSearchAttribute) {
                        sources.add((SourceSearchAttribute)item);
                        groupIterator.remove();
                        hasGraphSources = true;
                    }
                    if (!(item instanceof EmptySearchAttribute)) continue;
                    hasEmptySearchFields = true;
                }
            }
            if (attr instanceof DistanceSearchAttribute) {
                GeoCodingResult coords;
                DistanceSearchAttribute distanceSearch = (DistanceSearchAttribute)attr;
                if (distanceSearch.needsGeocding() && (coords = GeoHelper.geocode(distanceSearch)) != null) {
                    distanceSearch.setCoords(coords.toArray());
                }
                hasSpatialSource = true;
            }
            if (attr instanceof SourceSearchAttribute) {
                sources.add((SourceSearchAttribute)attr);
                hasGraphSources = true;
            }
            if (!(attr instanceof EmptySearchAttribute)) continue;
            hasEmptySearchFields = true;
        }
        if (!hasSpatialSource && !sources.isEmpty()) {
            intermediateResult = new Result(new ArrayList(), null, false, false);
        } else {
            Index<S> index;
            if (this.sortKey != null && !this.doNotSort) {
                this.rootGroup.setSortKey(this.sortKey);
                this.rootGroup.sortDescending(this.sortDescending);
            }
            if ((index = this.getIndex()) != null) {
                Iterable hits = this.getIndex().query((QueryPredicate)this.rootGroup);
                intermediateResult = factory.instantiate(hits);
            }
        }
        if (intermediateResult != null && (hasEmptySearchFields || hasGraphSources || hasSpatialSource)) {
            LinkedHashSet<GraphObject> intermediateResultSet = new LinkedHashSet<GraphObject>(intermediateResult.getResults());
            ArrayList<GraphObject> finalResult = new ArrayList<GraphObject>();
            int resultCount = 0;
            if (hasGraphSources) {
                Set<GraphObject> mergedSources = this.mergeSources(sources);
                if (hasSpatialSource) {
                    intermediateResultSet.retainAll(mergedSources);
                } else {
                    intermediateResultSet.addAll(mergedSources);
                }
            }
            for (GraphObject obj : intermediateResultSet) {
                boolean addToResult = true;
                for (SearchAttribute attr : this.rootGroup.getSearchAttributes()) {
                    addToResult &= attr.includeInResult(obj);
                }
                if (!addToResult) continue;
                finalResult.add(obj);
                ++resultCount;
            }
            Collections.sort(finalResult, new GraphObjectComparator(this.sortKey, this.sortDescending));
            return new Result<GraphObject>(PagingHelper.subList(finalResult, this.pageSize, this.page, this.offsetId), resultCount, true, false);
        }
        return intermediateResult;
    }

    private Set<GraphObject> mergeSources(List<SourceSearchAttribute> sources) {
        LinkedHashSet<GraphObject> mergedResult = new LinkedHashSet<GraphObject>();
        boolean alreadyAdded = false;
        for (SourceSearchAttribute attr : sources) {
            if (!alreadyAdded) {
                mergedResult.addAll(attr.getResult());
                alreadyAdded = true;
                continue;
            }
            switch (attr.getOccurrence()) {
                case REQUIRED: {
                    mergedResult.retainAll(attr.getResult());
                    break;
                }
                case OPTIONAL: {
                    mergedResult.addAll(attr.getResult());
                    break;
                }
                case FORBIDDEN: {
                    mergedResult.removeAll(attr.getResult());
                }
            }
        }
        return mergedResult;
    }

    @Override
    public Result<T> getResult() throws FrameworkException {
        return this.doSearch();
    }

    @Override
    public List<T> getAsList() throws FrameworkException {
        Result<T> result = this.getResult();
        if (result != null) {
            return result.getResults();
        }
        return Collections.emptyList();
    }

    @Override
    public T getFirst() throws FrameworkException {
        Result<T> result = this.getResult();
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public Query<T> sort(PropertyKey key) {
        return this.sortAscending(key);
    }

    @Override
    public Query<T> sortAscending(PropertyKey key) {
        this.doNotSort = false;
        this.sortDescending = false;
        this.sortKey = key;
        return this;
    }

    @Override
    public Query<T> sortDescending(PropertyKey key) {
        this.doNotSort = false;
        this.sortDescending = true;
        this.sortKey = key;
        return this;
    }

    @Override
    public Query<T> order(boolean descending) {
        this.doNotSort = false;
        this.sortDescending = descending;
        return this;
    }

    @Override
    public Query<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public Query<T> page(int page) {
        this.page = page;
        return this;
    }

    @Override
    public Query<T> publicOnly() {
        this.publicOnly = true;
        return this;
    }

    @Override
    public Query<T> publicOnly(boolean publicOnly) {
        this.publicOnly = publicOnly;
        return this;
    }

    @Override
    public Query<T> includeDeletedAndHidden() {
        this.includeDeletedAndHidden = true;
        return this;
    }

    @Override
    public Query<T> includeDeletedAndHidden(boolean includeDeletedAndHidden) {
        this.includeDeletedAndHidden = includeDeletedAndHidden;
        return this;
    }

    @Override
    public Query<T> offsetId(String offsetId) {
        this.offsetId = offsetId;
        return this;
    }

    @Override
    public Query<T> uuid(String uuid) {
        this.doNotSort = true;
        return this.and(GraphObject.id, uuid);
    }

    @Override
    public Query<T> andType(Class type) {
        this.currentGroup.getSearchAttributes().add(new TypeSearchAttribute(type, Occurrence.REQUIRED, true));
        return this;
    }

    @Override
    public Query<T> orType(Class type) {
        this.currentGroup.getSearchAttributes().add(new TypeSearchAttribute(type, Occurrence.OPTIONAL, true));
        return this;
    }

    @Override
    public Query<T> andTypes(Class type) {
        this.andType(type);
        return this;
    }

    @Override
    public Query<T> orTypes(Class type) {
        this.orType(type);
        return this;
    }

    @Override
    public Query<T> andName(String name) {
        return this.and(AbstractNode.name, name);
    }

    @Override
    public Query<T> orName(String name) {
        return this.or(AbstractNode.name, name);
    }

    @Override
    public Query<T> location(double latitude, double longitude, double distance) {
        this.currentGroup.getSearchAttributes().add(new DistanceSearchAttribute(latitude, longitude, distance, Occurrence.REQUIRED));
        return this;
    }

    @Override
    public Query<T> location(String street, String postalCode, String city, String country, double distance) {
        return this.location(street, null, postalCode, city, null, country, distance);
    }

    @Override
    public Query<T> location(String street, String postalCode, String city, String state, String country, double distance) {
        return this.location(street, null, postalCode, city, state, country, distance);
    }

    @Override
    public Query<T> location(String street, String house, String postalCode, String city, String state, String country, double distance) {
        this.currentGroup.getSearchAttributes().add(new DistanceSearchAttribute(street, house, postalCode, city, state, country, distance, Occurrence.REQUIRED));
        return this;
    }

    @Override
    public <P> Query<T> and(PropertyKey<P> key, P value) {
        if (GraphObject.id.equals(key)) {
            this.doNotSort = false;
        }
        return this.and(key, value, true);
    }

    @Override
    public <P> Query<T> and(PropertyKey<P> key, P value, boolean exact) {
        if (GraphObject.id.equals(key)) {
            this.doNotSort = false;
        }
        this.currentGroup.getSearchAttributes().add(key.getSearchAttribute(this.securityContext, Occurrence.REQUIRED, value, exact, this));
        return this;
    }

    @Override
    public <P> Query<T> and(PropertyMap attributes) {
        for (Map.Entry<PropertyKey, Object> entry : attributes.entrySet()) {
            PropertyKey key = entry.getKey();
            Object value = entry.getValue();
            if (GraphObject.id.equals(key)) {
                this.doNotSort = false;
            }
            this.and(key, value);
        }
        return this;
    }

    @Override
    public Query<T> and() {
        SearchAttributeGroup group = new SearchAttributeGroup(this.currentGroup, Occurrence.REQUIRED);
        this.currentGroup.getSearchAttributes().add(group);
        this.currentGroup = group;
        return this;
    }

    @Override
    public <P> Query<T> or(PropertyKey<P> key, P value) {
        return this.or(key, value, true);
    }

    @Override
    public <P> Query<T> or(PropertyKey<P> key, P value, boolean exact) {
        this.currentGroup.getSearchAttributes().add(key.getSearchAttribute(this.securityContext, Occurrence.OPTIONAL, value, exact, this));
        return this;
    }

    @Override
    public <P> Query<T> or(PropertyMap attributes) {
        for (Map.Entry<PropertyKey, Object> entry : attributes.entrySet()) {
            PropertyKey key = entry.getKey();
            Object value = entry.getValue();
            this.or(key, value);
        }
        return this;
    }

    @Override
    public Query<T> notBlank(PropertyKey key) {
        this.currentGroup.getSearchAttributes().add(new NotBlankSearchAttribute(key));
        return this;
    }

    @Override
    public Query<T> blank(PropertyKey key) {
        this.currentGroup.getSearchAttributes().add(new EmptySearchAttribute<Object>(key, null));
        return this;
    }

    @Override
    public <P> Query<T> andRange(PropertyKey<P> key, P rangeStart, P rangeEnd) {
        this.currentGroup.getSearchAttributes().add(new RangeSearchAttribute<P>(key, rangeStart, rangeEnd, Occurrence.REQUIRED));
        return this;
    }

    @Override
    public <P> Query<T> orRange(PropertyKey<P> key, P rangeStart, P rangeEnd) {
        this.currentGroup.getSearchAttributes().add(new RangeSearchAttribute<P>(key, rangeStart, rangeEnd, Occurrence.OPTIONAL));
        return this;
    }

    @Override
    public Query<T> or() {
        SearchAttributeGroup group = new SearchAttributeGroup(this.currentGroup, Occurrence.OPTIONAL);
        this.currentGroup.getSearchAttributes().add(group);
        this.currentGroup = group;
        return this;
    }

    @Override
    public Query<T> not() {
        SearchAttributeGroup group = new SearchAttributeGroup(this.currentGroup, Occurrence.FORBIDDEN);
        this.currentGroup.getSearchAttributes().add(group);
        this.currentGroup = group;
        return this;
    }

    @Override
    public Query<T> parent() {
        SearchAttributeGroup parent = this.currentGroup.getParent();
        if (parent != null) {
            this.currentGroup = parent;
        }
        return this;
    }

    @Override
    public Query<T> attributes(List<SearchAttribute> attributes) {
        this.currentGroup.getSearchAttributes().addAll(attributes);
        return this;
    }

    @Override
    public Predicate<GraphObject> toPredicate() {
        return new AndPredicate(this.rootGroup.getSearchAttributes());
    }

    @Override
    public Iterator<T> iterator() {
        try {
            return this.getAsList().iterator();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
            return null;
        }
    }

    @Override
    public SearchAttributeGroup getRootAttributeGroup() {
        return this.rootGroup;
    }

    public static synchronized void clearInheritanceMap() {
        subtypeMapForType.clear();
    }

    public static synchronized Set<String> getAllSubtypesAsStringSet(String type) {
        Set<String> allSubtypes = subtypeMapForType.get(type);
        if (allSubtypes == null) {
            String superClassFullName;
            String superClasSimpleName;
            Set<Class> ancestors;
            Class<GraphObject> entityType;
            allSubtypes = new LinkedHashSet<String>();
            subtypeMapForType.put(type, allSubtypes);
            ConfigurationProvider configuration = StructrApp.getConfiguration();
            Map<String, Class<? extends NodeInterface>> nodeEntities = configuration.getNodeEntities();
            Map<String, Class<? extends RelationshipInterface>> relEntities = configuration.getRelationshipEntities();
            allSubtypes.add(type);
            for (Map.Entry<String, Class<? extends NodeInterface>> entry : nodeEntities.entrySet()) {
                entityType = entry.getValue();
                ancestors = SearchCommand.typeAndAllSupertypes(entityType);
                for (Class superClass : ancestors) {
                    superClasSimpleName = superClass.getSimpleName();
                    superClassFullName = superClass.getName();
                    if (!superClassFullName.startsWith("org.structr.") && !superClassFullName.startsWith("com.structr.") || !superClasSimpleName.equals(type)) continue;
                    allSubtypes.add(entityType.getSimpleName());
                }
            }
            for (Map.Entry<String, Class<GraphObject>> entry : relEntities.entrySet()) {
                entityType = entry.getValue();
                ancestors = SearchCommand.typeAndAllSupertypes(entityType);
                for (Class superClass : ancestors) {
                    superClasSimpleName = superClass.getSimpleName();
                    superClassFullName = superClass.getName();
                    if (!superClassFullName.startsWith("org.structr.") && !superClassFullName.startsWith("com.structr.") || !superClasSimpleName.equals(type)) continue;
                    allSubtypes.add(entityType.getSimpleName());
                }
            }
        }
        return Collections.unmodifiableSet(allSubtypes);
    }

    public static boolean isTypeAssignableFromOtherType(Class type, Class otherType) {
        return SearchCommand.getAllSubtypesAsStringSet(type.getSimpleName()).contains(otherType.getSimpleName());
    }

    public static Set<Class> typeAndAllSupertypes(Class type) {
        ConfigurationProvider configuration = StructrApp.getConfiguration();
        LinkedHashSet<Class> allSupertypes = new LinkedHashSet<Class>();
        for (Class localType = type; localType != null && !localType.equals(Object.class); localType = localType.getSuperclass()) {
            allSupertypes.add(localType);
            allSupertypes.addAll(configuration.getInterfacesForType(localType));
        }
        allSupertypes.removeAll(baseTypes);
        return allSupertypes;
    }

    static {
        baseTypes.add(RelationshipInterface.class.getSimpleName());
        baseTypes.add(AbstractRelationship.class.getSimpleName());
        baseTypes.add(NodeInterface.class.getSimpleName());
        baseTypes.add(AbstractNode.class.getSimpleName());
    }

    private class AndPredicate
    implements Predicate<GraphObject> {
        final List<Predicate<GraphObject>> predicates = new ArrayList<Predicate<GraphObject>>();

        public AndPredicate(List<SearchAttribute> searchAttributes) {
            for (SearchAttribute attr : searchAttributes) {
                if (attr instanceof SearchAttributeGroup) {
                    for (SearchAttribute groupAttr : ((SearchAttributeGroup)attr).getSearchAttributes()) {
                        if (groupAttr instanceof TypeSearchAttribute) continue;
                        this.predicates.add(attr);
                    }
                    continue;
                }
                if (attr instanceof TypeSearchAttribute) continue;
                this.predicates.add(attr);
            }
        }

        public boolean accept(GraphObject obj) {
            boolean result = true;
            for (Predicate<GraphObject> predicate : this.predicates) {
                result &= predicate.accept((Object)obj);
            }
            return result;
        }
    }
}

