/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.parser;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.StaticValue;
import org.structr.core.parser.Expression;
import org.structr.schema.action.ActionContext;

public class BatchExpression
extends Expression {
    private static final Logger logger = LoggerFactory.getLogger(BatchExpression.class);
    public static final String ERROR_MESSAGE_SLICE = "Usage: ${batch(statement, batchSize)}. Example: ${batch(delete(find('User')), 1000)}";
    private Expression batchExpression = null;
    private Expression sizeExpression = null;
    private boolean background = false;
    private int batchSize = -1;

    public BatchExpression() {
        super("batch");
    }

    @Override
    public void add(Expression expression) throws FrameworkException {
        if (this.batchExpression == null) {
            this.batchExpression = expression;
        } else if (this.sizeExpression == null) {
            this.sizeExpression = expression;
        } else {
            throw new FrameworkException(422, "Invalid batch() expression in builtin function: too many parameters.");
        }
        expression.parent = this;
        expression.level = this.level + 1;
    }

    @Override
    public Object evaluate(ActionContext ctx, GraphObject entity) throws FrameworkException, UnlicensedException {
        if (this.batchExpression == null || this.sizeExpression == null) {
            return ERROR_MESSAGE_SLICE;
        }
        Object value = this.sizeExpression.evaluate(ctx, entity);
        if (value != null && value instanceof Number) {
            this.batchSize = ((Number)value).intValue();
            StaticValue<Object> exception = new StaticValue<Object>(null);
            StaticValue<Object> result = new StaticValue<Object>(null);
            Thread workerThread = new Thread(() -> {
                try {
                    result.set(null, this.batchExpression.evaluate(ctx, entity));
                }
                catch (FrameworkException fex) {
                    exception.set(null, fex);
                }
            });
            workerThread.start();
            try {
                workerThread.join();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (exception.get(null) != null) {
                throw (FrameworkException)exception.get(null);
            }
            return result.get(null);
        }
        throw new FrameworkException(422, "Error in batch(): invalid batch size, expecting number.");
    }

    @Override
    public Object transform(ActionContext ctx, GraphObject entity, Object source) throws FrameworkException, UnlicensedException {
        return source;
    }

    @Override
    public boolean isBatched() {
        return true;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }
}

