/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.parser;

import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.Services;
import org.structr.core.parser.Expression;
import org.structr.schema.action.ActionContext;

public class CacheExpression
extends Expression {
    public static final String ERROR_MESSAGE_CACHE = "Usage: ${cache(key, timeout, valueExpression)}. Example: ${cache('value', 60, GET('http://rate-limited-URL.com'))}";
    private Expression keyExpression = null;
    private Expression timeoutExpression = null;
    private Expression valueExpression = null;

    public CacheExpression() {
        super("cache");
    }

    @Override
    public void add(Expression expression) throws FrameworkException {
        if (this.keyExpression == null) {
            this.keyExpression = expression;
        } else if (this.timeoutExpression == null) {
            this.timeoutExpression = expression;
        } else if (this.valueExpression == null) {
            this.valueExpression = expression;
        } else {
            throw new FrameworkException(422, "Invalid cache() expression in builtin function: too many parameters.");
        }
        expression.parent = this;
        expression.level = this.level + 1;
    }

    @Override
    public Object evaluate(ActionContext ctx, GraphObject entity) throws FrameworkException, UnlicensedException {
        if (this.keyExpression == null) {
            return "Error: cache(): key expression may not be empty.";
        }
        Object keyObject = this.keyExpression.evaluate(ctx, entity);
        if (keyObject == null) {
            return "Error: cache(): key may not be empty.";
        }
        String key = keyObject.toString();
        if (StringUtils.isBlank((CharSequence)key)) {
            return "Error: cache(): key may not be empty.";
        }
        if (this.timeoutExpression == null) {
            return "Error: cache(): timeout expression may not be empty.";
        }
        Object timeoutValue = this.timeoutExpression.evaluate(ctx, entity);
        if (timeoutValue == null || !(timeoutValue instanceof Number)) {
            return "Error: cache(): timeout must be non-empty and a number.";
        }
        if (this.valueExpression == null) {
            return "Error: cache(): value expression may not be empty.";
        }
        long timeout = ((Number)timeoutValue).longValue();
        Services services = Services.getInstance();
        CachedValue cachedValue = (CachedValue)services.getAttribute(key);
        if (cachedValue == null) {
            cachedValue = new CachedValue(timeout);
            services.setAttribute(key, cachedValue);
        } else {
            cachedValue.setTimeoutSeconds(timeout);
        }
        if (cachedValue.isExpired()) {
            cachedValue.refresh(this.valueExpression.evaluate(ctx, entity));
        }
        return cachedValue.getValue();
    }

    @Override
    public Object transform(ActionContext ctx, GraphObject entity, Object source) throws FrameworkException {
        return source;
    }

    private static final class CachedValue {
        private Random random = new Random(System.currentTimeMillis());
        private Object value = null;
        private long timeoutSeconds = 0L;
        private long timeout = 0L;

        public CachedValue(long timeoutSeconds) {
            this.setTimeoutSeconds(timeoutSeconds);
        }

        public final void setTimeoutSeconds(long timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        public final Object getValue() {
            return this.value;
        }

        public final boolean isExpired() {
            return System.currentTimeMillis() > this.timeout;
        }

        public final void refresh(Object value) {
            this.timeout = System.currentTimeMillis() + (this.timeoutSeconds + (long)this.random.nextInt(10)) * 1000L;
            this.value = value;
        }
    }
}

