/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.parser;

import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.parser.Expression;
import org.structr.schema.action.ActionContext;

public class EachExpression
extends Expression {
    private static final Logger logger = LoggerFactory.getLogger(EachExpression.class);
    public static final String ERROR_MESSAGE_EACH = "Usage: ${each(collection, expression)}. Example: ${each(this.children, \"set(this, \"email\", lower(get(this.email))))\")}";
    private Expression listExpression = null;
    private Expression eachExpression = null;

    public EachExpression() {
        super("each");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("each(");
        for (Expression expr : this.expressions) {
            buf.append(expr.toString());
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public void add(Expression expression) throws FrameworkException {
        if (this.listExpression == null) {
            this.listExpression = expression;
        } else if (this.eachExpression == null) {
            this.eachExpression = expression;
        } else {
            throw new FrameworkException(422, "Invalid each() expression in builtin function: too many parameters.");
        }
        expression.parent = this;
        expression.level = this.level + 1;
    }

    @Override
    public Object evaluate(ActionContext ctx, GraphObject entity) throws FrameworkException, UnlicensedException {
        if (this.listExpression == null) {
            return ERROR_MESSAGE_EACH;
        }
        Object listSource = this.listExpression.evaluate(ctx, entity);
        if (listSource != null && listSource instanceof Iterable) {
            Iterable source = (Iterable)listSource;
            Object oldDataValue = ctx.getConstant("data");
            if (this.isBatched()) {
                App app = StructrApp.getInstance(ctx.getSecurityContext());
                Iterator iterator = source.iterator();
                int count = 0;
                while (iterator.hasNext()) {
                    try (Tx tx = app.tx();){
                        while (iterator.hasNext()) {
                            ctx.setConstant("data", iterator.next());
                            this.eachExpression.evaluate(ctx, entity);
                            if (++count % this.getBatchSize() != 0) continue;
                        }
                        tx.success();
                    }
                    catch (FrameworkException fex) {
                        logger.warn(fex.getMessage());
                        logger.warn(fex.toString());
                        fex.printStackTrace();
                    }
                    logger.info("Commiting batch after {} objects", (Object)count);
                    count = 0;
                }
            } else {
                for (Object obj : source) {
                    ctx.setConstant("data", obj);
                    this.eachExpression.evaluate(ctx, entity);
                }
            }
            ctx.setConstant("data", oldDataValue);
        }
        return null;
    }

    @Override
    public Object transform(ActionContext ctx, GraphObject entity, Object source) throws FrameworkException, UnlicensedException {
        return source;
    }
}

