/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.parser;

import java.util.LinkedList;
import java.util.List;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.schema.action.ActionContext;

public abstract class Expression {
    protected List<Expression> expressions = new LinkedList<Expression>();
    protected Expression parent = null;
    protected String name = null;
    protected int level = 0;

    public Expression() {
        this(null);
    }

    public Expression(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public void add(Expression expression) throws FrameworkException {
        expression.parent = this;
        expression.level = this.level + 1;
        this.expressions.add(expression);
    }

    public void replacePrevious(Expression newExpression) throws FrameworkException {
        if (this.hasPrevious()) {
            this.expressions.remove(this.expressions.size() - 1);
            this.add(newExpression);
        }
    }

    public Expression getParent() {
        return this.parent;
    }

    public Expression getPrevious() {
        if (!this.expressions.isEmpty()) {
            return this.expressions.get(this.expressions.size() - 1);
        }
        return null;
    }

    public boolean hasPrevious() {
        return !this.expressions.isEmpty();
    }

    public boolean isBatched() {
        return this.parent != null && this.parent.isBatched();
    }

    public int getBatchSize() {
        if (this.parent != null) {
            return this.parent.getBatchSize();
        }
        return -1;
    }

    public abstract Object evaluate(ActionContext var1, GraphObject var2) throws FrameworkException, UnlicensedException;

    public abstract Object transform(ActionContext var1, GraphObject var2, Object var3) throws FrameworkException, UnlicensedException;
}

