/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.parser;

import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.parser.Expression;
import org.structr.core.parser.FunctionExpression;
import org.structr.core.parser.ValueExpression;
import org.structr.schema.action.ActionContext;

public class FunctionValueExpression
extends Expression {
    private final FunctionExpression functionExpression;
    private final ValueExpression valueExpression;

    public FunctionValueExpression(FunctionExpression functionExpression, ValueExpression valueExpression) {
        this.functionExpression = functionExpression;
        this.valueExpression = valueExpression;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.functionExpression.toString()).append(this.valueExpression.toString());
        return buf.toString();
    }

    @Override
    public Object evaluate(ActionContext ctx, GraphObject entity) throws FrameworkException, UnlicensedException {
        Object value = this.functionExpression.evaluate(ctx, entity);
        value = this.valueExpression.transform(ctx, entity, value);
        for (Expression expression : this.valueExpression.expressions) {
            value = expression.transform(ctx, entity, value);
        }
        return value;
    }

    @Override
    public Object transform(ActionContext ctx, GraphObject entity, Object source) throws FrameworkException, UnlicensedException {
        return source;
    }
}

