/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.parser;

import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.parser.Expression;
import org.structr.schema.action.ActionContext;

public class IsExpression
extends Expression {
    public static final String ERROR_MESSAGE_IS = "Usage: ${is(condition, trueValue)}. Example: ${is(equal(this.name, request.name), 'selected')}";

    public IsExpression() {
        super("is");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("is(");
        for (Expression expr : this.expressions) {
            buf.append(expr.toString());
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public void add(Expression expression) throws FrameworkException {
        if (this.expressions.size() == 2) {
            throw new FrameworkException(422, "Invalid is() expression in builtin function: too many parameters.");
        }
        super.add(expression);
    }

    @Override
    public Object evaluate(ActionContext ctx, GraphObject entity) throws FrameworkException, UnlicensedException {
        if (this.expressions.isEmpty()) {
            return ERROR_MESSAGE_IS;
        }
        Expression condition = (Expression)this.expressions.get(0);
        if (this.isTrue(condition.evaluate(ctx, entity))) {
            if (this.expressions.size() > 1) {
                Expression trueExpression = (Expression)this.expressions.get(1);
                return trueExpression.evaluate(ctx, entity);
            }
            throw new FrameworkException(422, "Invalid is() expression in builtin function: missing trueExpression.");
        }
        return "___NULL___";
    }

    private boolean isTrue(Object source) {
        return source != null && (Boolean.TRUE.equals(source) || "true".equals(source));
    }

    @Override
    public Object transform(ActionContext ctx, GraphObject entity, Object source) throws FrameworkException, UnlicensedException {
        return source;
    }
}

