/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.parser;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.function.QueryFunction;
import org.structr.core.parser.Expression;
import org.structr.schema.action.ActionContext;

public class SliceExpression
extends Expression {
    private static final Logger logger = LoggerFactory.getLogger(SliceExpression.class);
    public static final String ERROR_MESSAGE_SLICE = "Usage: ${slice(collection, start, end)}. Example: ${slice(this.children, 0, 10)}";
    private Expression listExpression = null;
    private Expression startExpression = null;
    private Expression endExpression = null;

    public SliceExpression() {
        super("slice");
    }

    @Override
    public void add(Expression expression) throws FrameworkException {
        if (this.listExpression == null) {
            this.listExpression = expression;
        } else if (this.startExpression == null) {
            this.startExpression = expression;
        } else if (this.endExpression == null) {
            this.endExpression = expression;
        } else {
            throw new FrameworkException(422, "Invalid slice() expression in builtin function: too many parameters.");
        }
        expression.parent = this;
        expression.level = this.level + 1;
    }

    @Override
    public Object evaluate(ActionContext ctx, GraphObject entity) throws FrameworkException, UnlicensedException {
        if (this.listExpression == null || this.startExpression == null || this.endExpression == null) {
            return ERROR_MESSAGE_SLICE;
        }
        Object startObject = this.startExpression.evaluate(ctx, entity);
        Object endObject = this.endExpression.evaluate(ctx, entity);
        if (startObject == null) {
            throw new FrameworkException(422, "Error in slice(): invalid start of range: null");
        }
        if (endObject == null) {
            throw new FrameworkException(422, "Error in slice(): invalid end of range: null");
        }
        Integer start = this.toNumber(startObject);
        Integer end = this.toNumber(endObject);
        boolean valid = true;
        if (start == null || end == null) {
            return null;
        }
        if (start < 0) {
            valid = false;
            logger.warn("Error in slice(): start index must be > 0.");
        }
        if (end < 0) {
            valid = false;
            logger.warn("Error in slice(): end index must be > 0.");
        }
        if (start > end) {
            valid = false;
            logger.warn("Error in slice(): start index must be <= end index.");
        }
        if (valid) {
            if (this.listExpression instanceof QueryFunction) {
                QueryFunction queryFunction = (QueryFunction)((Object)this.listExpression);
                queryFunction.setRangeStart(start);
                queryFunction.setRangeEnd(end);
                return this.listExpression.evaluate(ctx, entity);
            }
            Object src = this.listExpression.evaluate(ctx, entity);
            LinkedList list = null;
            if (src instanceof List) {
                list = (LinkedList)src;
            } else if (this.isArray(src)) {
                list = this.toList((Object[])src);
            } else if (src != null) {
                list = new LinkedList((Collection)src);
            } else {
                return null;
            }
            if (start > list.size()) {
                valid = false;
                logger.warn("Error in slice(): start index is out of range.");
            }
            if (end > list.size()) {
                end = list.size();
            }
            if (valid) {
                return list.subList(start, end);
            }
        }
        return null;
    }

    @Override
    public Object transform(ActionContext ctx, GraphObject entity, Object source) throws FrameworkException, UnlicensedException {
        return source;
    }

    private Integer toNumber(Object src) {
        if (src instanceof Number) {
            return ((Number)src).intValue();
        }
        if (src instanceof String) {
            try {
                return Integer.valueOf(src.toString());
            }
            catch (NumberFormatException nfex) {
                logger.warn("Error in slice(): Cannot parse number {}.", src);
            }
        }
        return null;
    }

    private boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    private List toList(Object[] obj) {
        return Arrays.asList(obj);
    }
}

