/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.parser;

import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.parser.Expression;
import org.structr.schema.action.ActionContext;

public class ValueExpression
extends Expression {
    private String keyword = null;

    public ValueExpression(String keyword) {
        this.keyword = keyword;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.keyword);
        buf.append("(");
        for (Expression expr : this.expressions) {
            buf.append(expr.toString());
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public Object evaluate(ActionContext ctx, GraphObject entity) throws FrameworkException, UnlicensedException {
        Object value = ctx.getReferencedProperty(entity, this.keyword, null, 0);
        for (Expression expression : this.expressions) {
            value = expression.transform(ctx, entity, value);
        }
        return value;
    }

    @Override
    public Object transform(ActionContext ctx, GraphObject entity, Object value) throws FrameworkException, UnlicensedException {
        if (this.keyword.startsWith(".")) {
            String key = this.keyword.substring(1);
            if (value instanceof GraphObject) {
                return ctx.getReferencedProperty(entity, key, value, 1);
            }
            if (value instanceof Map) {
                return ((Map)value).get(key);
            }
        }
        return value;
    }
}

