/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.NotInTransactionException;
import org.structr.api.Predicate;
import org.structr.api.graph.PropertyContainer;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.Principal;
import org.structr.core.entity.SuperUser;
import org.structr.core.graph.CreationContainer;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyMap;

public abstract class AbstractPrimitiveProperty<T>
extends Property<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractPrimitiveProperty.class.getName());
    protected GraphObject entity;
    protected SecurityContext securityContext;

    public AbstractPrimitiveProperty(String name) {
        super(name);
    }

    public AbstractPrimitiveProperty(String jsonName, String dbName) {
        super(jsonName, dbName);
    }

    public AbstractPrimitiveProperty(String jsonName, String dbName, T defaultValue) {
        super(jsonName, dbName, defaultValue);
    }

    @Override
    public T getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, null);
    }

    @Override
    public T getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        PropertyConverter<Object, ?> converter;
        Object value = null;
        PropertyContainer propertyContainer = obj.getPropertyContainer();
        if (propertyContainer != null && propertyContainer.hasProperty(this.dbName())) {
            value = propertyContainer.getProperty(this.dbName());
        }
        if (applyConverter && (converter = this.databaseConverter(securityContext, PropertyMap.unwrap(obj))) != null) {
            try {
                value = converter.revert(value);
            }
            catch (Throwable t) {
                logger.warn("Unable to convert property {} of type {}: {}", new Object[]{this.dbName(), this.getClass().getSimpleName(), t});
                logger.warn("", t);
            }
        }
        if (value == null) {
            value = this.defaultValue();
        }
        return (T)value;
    }

    @Override
    public Object setProperty(SecurityContext securityContext, GraphObject obj, T value) throws FrameworkException {
        PropertyConverter converter = this.databaseConverter(securityContext, PropertyMap.unwrap(obj));
        Object convertedValue = converter != null ? converter.convert(value) : value;
        PropertyContainer propertyContainer = obj.getPropertyContainer();
        if (propertyContainer != null) {
            if (!TransactionCommand.inTransaction()) {
                throw new NotInTransactionException("setProperty outside of transaction");
            }
            boolean internalSystemPropertiesUnlocked = obj instanceof CreationContainer;
            if (obj instanceof AbstractNode) {
                if (!this.unvalidated) {
                    TransactionCommand.nodeModified(securityContext.getCachedUser(), (AbstractNode)obj, this, propertyContainer.hasProperty(this.dbName()) ? propertyContainer.getProperty(this.dbName()) : null, value);
                }
                internalSystemPropertiesUnlocked = ((AbstractNode)obj).internalSystemPropertiesUnlocked;
            } else if (obj instanceof AbstractRelationship) {
                if (!this.unvalidated) {
                    TransactionCommand.relationshipModified(securityContext.getCachedUser(), (AbstractRelationship)obj, this, propertyContainer.hasProperty(this.dbName()) ? propertyContainer.getProperty(this.dbName()) : null, value);
                }
                internalSystemPropertiesUnlocked = ((AbstractRelationship)obj).internalSystemPropertiesUnlocked;
            }
            try {
                if (convertedValue == null) {
                    propertyContainer.removeProperty(this.dbName());
                } else if (!this.isSystemInternal() || internalSystemPropertiesUnlocked) {
                    propertyContainer.setProperty(this.dbName(), convertedValue);
                } else {
                    logger.warn("Tried to set internal system property {} to {}. Action was denied.", new Object[]{this.dbName(), convertedValue});
                }
                this.updateAccessInformation(securityContext, propertyContainer);
            }
            catch (Throwable t) {
                FrameworkException fex = new FrameworkException(500, "Unable to set property " + this.jsonName() + " on entity with ID " + obj.getUuid() + ": " + t.toString());
                fex.initCause(t);
                throw fex;
            }
            if (this.isIndexed() && !this.isPassivelyIndexed()) {
                this.index(obj, convertedValue);
            }
        }
        return null;
    }

    @Override
    public Class relatedType() {
        return null;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    private void updateAccessInformation(SecurityContext securityContext, PropertyContainer propertyContainer) throws FrameworkException {
        try {
            if (!securityContext.dontModifyAccessTime()) {
                Principal user = securityContext.getUser(false);
                String modifiedById = null;
                if (user != null) {
                    modifiedById = user instanceof SuperUser ? "00000000000000000000000000000000" : user.getUuid();
                    propertyContainer.setProperty(AbstractNode.lastModifiedBy.dbName(), (Object)modifiedById);
                }
                propertyContainer.setProperty(AbstractNode.lastModifiedDate.dbName(), (Object)System.currentTimeMillis());
            }
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
    }
}

