/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.AbstractPrimitiveProperty;
import org.structr.core.property.Property;

public class BooleanProperty
extends AbstractPrimitiveProperty<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger((String)BooleanProperty.class.getName());
    private static final Set<String> TRUE_VALUES = new LinkedHashSet<String>(Arrays.asList("true", "1", "on"));

    public BooleanProperty(String name) {
        super(name);
    }

    public BooleanProperty(String jsonName, String dbName) {
        super(jsonName, dbName);
    }

    @Override
    public Property<Boolean> indexed() {
        return super.passivelyIndexed();
    }

    @Override
    public String typeName() {
        return "Boolean";
    }

    @Override
    public Class valueType() {
        return Boolean.class;
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }

    @Override
    public PropertyConverter<Boolean, ?> databaseConverter(SecurityContext securityContext) {
        return this.databaseConverter(securityContext, null);
    }

    @Override
    public PropertyConverter<Boolean, ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        this.securityContext = securityContext;
        this.entity = entity;
        return new DatabaseConverter(securityContext);
    }

    @Override
    public PropertyConverter<?, Boolean> inputConverter(SecurityContext securityContext) {
        return new InputConverter(securityContext);
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        if (value != null) {
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof String) {
                boolean fixedValue = TRUE_VALUES.contains(value.toString().toLowerCase());
                if (this.entity != null) {
                    try {
                        this.setProperty(this.securityContext, this.entity, fixedValue);
                    }
                    catch (FrameworkException fex) {
                        logger.error("Cound not set fixed property {} on graph object {}", new Object[]{fixedValue, this.entity});
                    }
                }
                return fixedValue;
            }
        }
        return false;
    }

    @Override
    public PropertyType getDataType() {
        return PropertyType.BOOLEAN;
    }

    protected class InputConverter
    extends PropertyConverter<Object, Boolean> {
        public InputConverter(SecurityContext securityContext) {
            super(securityContext);
        }

        @Override
        public Object revert(Boolean source) throws FrameworkException {
            if (source != null) {
                return source;
            }
            return false;
        }

        @Override
        public Boolean convert(Object source) {
            boolean returnValue = false;
            if (source != null) {
                if (source instanceof Boolean) {
                    return (Boolean)source;
                }
                if (source instanceof String) {
                    returnValue = TRUE_VALUES.contains(source.toString().toLowerCase());
                }
            }
            return returnValue;
        }
    }

    protected class DatabaseConverter
    extends PropertyConverter<Boolean, Object> {
        public DatabaseConverter(SecurityContext securityContext) {
            super(securityContext);
        }

        @Override
        public Boolean revert(Object source) throws FrameworkException {
            if (source != null) {
                if (!(source instanceof Boolean)) {
                    logger.warn("Wrong database type for {}. Expected: {}, found: {}", new Object[]{BooleanProperty.this.dbName, Boolean.class.getName(), source.getClass().getName()});
                    return (Boolean)BooleanProperty.this.fixDatabaseProperty(source);
                }
                return (Boolean)source;
            }
            return BooleanProperty.this.defaultValue != null ? (Boolean)BooleanProperty.this.defaultValue : false;
        }

        @Override
        public Boolean convert(Boolean source) {
            if (source != null) {
                return source;
            }
            return false;
        }
    }
}

