/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.List;
import org.structr.api.Predicate;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.AbstractReadOnlyProperty;
import org.structr.core.property.Property;

public class CollectionSumProperty<T extends NodeInterface, S extends Number>
extends AbstractReadOnlyProperty<S> {
    private Property<List<T>> collectionKey = null;
    private Property<S> valueKey = null;
    private Predicate<T> predicate = null;

    public CollectionSumProperty(String name, Property<List<T>> collectionKey, Property<S> valueKey) {
        super(name);
        this.collectionKey = collectionKey;
        this.valueKey = valueKey;
    }

    public CollectionSumProperty(String name, Property<List<T>> collectionKey, Property<S> valueKey, Predicate<T> predicate) {
        this(name, collectionKey, valueKey);
        this.predicate = predicate;
    }

    @Override
    public Class relatedType() {
        return null;
    }

    @Override
    public Class valueType() {
        return this.valueKey.valueType();
    }

    @Override
    public SortType getSortType() {
        return SortType.Integer;
    }

    @Override
    public S getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return (S)this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    @Override
    public S getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> pred) {
        int intSum = 0;
        long longSum = 0L;
        double doubleSum = 0.0;
        float floatSum = 0.0f;
        Class cls = Integer.class;
        for (NodeInterface collectionObj : obj.getProperty(this.collectionKey)) {
            if (this.predicate != null && !this.predicate.accept((Object)collectionObj)) continue;
            Number value = (Number)collectionObj.getProperty(this.valueKey);
            if (value instanceof Integer) {
                intSum += ((Integer)value).intValue();
                continue;
            }
            if (value instanceof Long) {
                longSum += ((Long)value).longValue();
                cls = Long.class;
                continue;
            }
            if (value instanceof Double) {
                doubleSum += ((Double)value).doubleValue();
                cls = Double.class;
                continue;
            }
            if (!(value instanceof Float)) continue;
            floatSum += ((Float)value).floatValue();
            cls = Float.class;
        }
        switch (cls.getSimpleName()) {
            case "Integer": {
                return (S)Integer.valueOf(intSum);
            }
            case "Long": {
                return (S)Long.valueOf(longSum);
            }
            case "Double": {
                return (S)Double.valueOf(doubleSum);
            }
            case "Float": {
                return (S)Float.valueOf(floatSum);
            }
        }
        return (S)Integer.valueOf(intSum);
    }

    @Override
    public boolean isCollection() {
        return false;
    }
}

