/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.structr.api.Predicate;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.ReadOnlyPropertyToken;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.AbstractPrimitiveProperty;

public class ConstantBooleanProperty
extends AbstractPrimitiveProperty<Boolean> {
    private boolean constantValue;

    public ConstantBooleanProperty(String name, boolean constantValue) {
        super(name);
        this.systemInternal();
        this.readOnly();
        this.constantValue = constantValue;
    }

    public ConstantBooleanProperty(String jsonName, String dbName, boolean constantValue) {
        super(jsonName, dbName);
    }

    @Override
    public Boolean getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    @Override
    public Boolean getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        if (this.declaringClass.isAssignableFrom(obj.getClass())) {
            return this.constantValue;
        }
        return false;
    }

    @Override
    public Object setProperty(SecurityContext securityContext, GraphObject obj, Boolean value) throws FrameworkException {
        throw new FrameworkException(422, "Unable to change value of a constant property", new ReadOnlyPropertyToken(obj.getType(), this));
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isSystemInternal() {
        return true;
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String typeName() {
        return "Boolean";
    }

    @Override
    public Class valueType() {
        return Boolean.class;
    }

    @Override
    public PropertyConverter<Boolean, ?> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<Boolean, ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return null;
    }

    @Override
    public PropertyConverter<?, Boolean> inputConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }

    @Override
    public PropertyType getDataType() {
        return PropertyType.BOOLEAN;
    }
}

