/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.AbstractPrimitiveProperty;

public class ConverterProperty<T>
extends AbstractPrimitiveProperty<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)ConverterProperty.class.getName());
    private Constructor constructor = null;

    public ConverterProperty(String name, Class<? extends PropertyConverter<?, T>> converterClass) {
        super(name);
        try {
            this.constructor = converterClass.getConstructor(SecurityContext.class, GraphObject.class);
        }
        catch (NoSuchMethodException nsmex) {
            logger.error("Unable to instantiate converter of type {} for key {}", new Object[]{converterClass.getName(), name});
        }
        StructrApp.getConfiguration().registerConvertedProperty(this);
    }

    @Override
    public String typeName() {
        return "";
    }

    @Override
    public Class valueType() {
        return null;
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        return null;
    }

    @Override
    public PropertyConverter<T, ?> databaseConverter(SecurityContext securityContext) {
        return this.databaseConverter(securityContext, null);
    }

    @Override
    public PropertyConverter<T, ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return this.createConverter(securityContext, entity);
    }

    @Override
    public PropertyConverter<?, T> inputConverter(SecurityContext securityContext) {
        return null;
    }

    private PropertyConverter createConverter(SecurityContext securityContext, GraphObject entity) {
        try {
            return (PropertyConverter)this.constructor.newInstance(securityContext, entity);
        }
        catch (Throwable t) {
            logger.error("Unable to instantiate converter of type {} for key {}", new Object[]{this.constructor.getClass().getName(), this.dbName});
            return null;
        }
    }
}

