/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.commons.lang3.StringUtils;
import org.structr.api.config.Settings;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.NumberToken;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.AbstractPrimitiveProperty;
import org.structr.core.property.NumericalPropertyKey;

public class DoubleProperty
extends AbstractPrimitiveProperty<Double>
implements NumericalPropertyKey<Double> {
    public DoubleProperty(String name) {
        this(name, name, null);
    }

    public DoubleProperty(String jsonName, String dbName) {
        this(jsonName, dbName, null);
    }

    public DoubleProperty(String name, Double defaultValue) {
        this(name, name, defaultValue);
    }

    public DoubleProperty(String jsonName, String dbName, Double defaultValue) {
        super(jsonName, dbName, defaultValue);
        if (jsonName.equals("latitude") || jsonName.equals("longitude")) {
            this.passivelyIndexed();
        }
    }

    @Override
    public String typeName() {
        return "Double";
    }

    @Override
    public Class valueType() {
        return Double.class;
    }

    @Override
    public SortType getSortType() {
        return SortType.Double;
    }

    @Override
    public PropertyConverter<Double, ?> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<Double, ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return null;
    }

    @Override
    public PropertyConverter<?, Double> inputConverter(SecurityContext securityContext) {
        return new InputConverter(securityContext);
    }

    @Override
    public Double convertToNumber(Double source) {
        return source;
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        if (value != null) {
            if (value instanceof Double) {
                return value;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            try {
                return Double.parseDouble(value.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void index(GraphObject entity, Object value) {
        super.index(entity, this.fixDatabaseProperty(value));
    }

    @Override
    public PropertyType getDataType() {
        return PropertyType.DECIMAL;
    }

    protected class InputConverter
    extends PropertyConverter<Object, Double> {
        public InputConverter(SecurityContext securityContext) {
            super(securityContext);
        }

        @Override
        public Object revert(Double source) throws FrameworkException {
            if (source == null) {
                return null;
            }
            boolean lenient = (Boolean)Settings.JsonLenient.getValue();
            if (!lenient) {
                if (Double.isNaN(source)) {
                    return null;
                }
                if (Double.isInfinite(source)) {
                    return null;
                }
            }
            return source;
        }

        @Override
        public Double convert(Object source) throws FrameworkException {
            if (source == null) {
                return null;
            }
            if (source instanceof Number) {
                return ((Number)source).doubleValue();
            }
            if (source instanceof String && StringUtils.isNotBlank((CharSequence)((String)source))) {
                try {
                    return Double.valueOf(source.toString());
                }
                catch (Throwable t) {
                    throw new FrameworkException(422, "Cannot parse input for property " + DoubleProperty.this.jsonName(), new NumberToken(DoubleProperty.this.declaringClass.getSimpleName(), DoubleProperty.this));
                }
            }
            return null;
        }
    }
}

