/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.Property;
import org.structr.core.script.Scripting;
import org.structr.schema.action.ActionContext;

public class FunctionProperty<T>
extends Property<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)FunctionProperty.class.getName());

    public FunctionProperty(String name) {
        super(name);
    }

    @Override
    public Property<T> indexed() {
        super.indexed();
        super.passivelyIndexed();
        return this;
    }

    @Override
    public Class relatedType() {
        return null;
    }

    @Override
    public T getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, null);
    }

    @Override
    public T getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        try {
            if (obj != null && this.readFunction != null) {
                ActionContext actionContext = new ActionContext(securityContext);
                actionContext.setPredicate(predicate);
                return (T)Scripting.evaluate(actionContext, obj, "${".concat(this.readFunction).concat("}"), "getProperty(" + this.jsonName + ")");
            }
            logger.warn("Unable to evaluate function property {}, object was null.", (Object)this.jsonName());
        }
        catch (Throwable t) {
            logger.warn("Exception while evaluating read function in Function property \"{}\"", (Object)this.jsonName());
        }
        return null;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }

    @Override
    public Class valueType() {
        return Object.class;
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        return value;
    }

    @Override
    public String typeName() {
        return "Object";
    }

    @Override
    public PropertyConverter<T, ?> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<T, ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return null;
    }

    @Override
    public PropertyConverter<?, T> inputConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public Object setProperty(SecurityContext securityContext, GraphObject obj, T value) throws FrameworkException {
        try {
            ActionContext ctx = new ActionContext(securityContext);
            ctx.setConstant("value", value);
            return Scripting.evaluate(ctx, obj, "${".concat(this.writeFunction).concat("}"), "setProperty(" + this.jsonName + ")");
        }
        catch (Throwable t) {
            logger.warn("Exception while evaluating write function in Function property \"{}\"", (Object)this.jsonName());
            return null;
        }
    }

    @Override
    public Property<T> format(String format) {
        this.readFunction = format;
        return this;
    }
}

