/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.NumberToken;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.AbstractPrimitiveProperty;
import org.structr.core.property.NumericalPropertyKey;

public class IntProperty
extends AbstractPrimitiveProperty<Integer>
implements NumericalPropertyKey<Integer> {
    private static final Logger logger = LoggerFactory.getLogger((String)IntProperty.class.getName());

    public IntProperty(String name) {
        super(name);
    }

    @Override
    public String typeName() {
        return "Integer";
    }

    @Override
    public Class valueType() {
        return Integer.class;
    }

    @Override
    public SortType getSortType() {
        return SortType.Integer;
    }

    @Override
    public PropertyConverter<Integer, Integer> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<Integer, ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return new DatabaseConverter(securityContext);
    }

    @Override
    public PropertyConverter<?, Integer> inputConverter(SecurityContext securityContext) {
        return new InputConverter(securityContext);
    }

    @Override
    public Integer convertToNumber(Double source) {
        if (source != null) {
            return source.intValue();
        }
        return null;
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        if (value != null) {
            if (value instanceof Integer) {
                return value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            try {
                return Double.valueOf(value.toString()).intValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void index(GraphObject entity, Object value) {
        super.index(entity, this.fixDatabaseProperty(value));
    }

    @Override
    public PropertyType getDataType() {
        return PropertyType.INTEGER;
    }

    protected class InputConverter
    extends PropertyConverter<Object, Integer> {
        public InputConverter(SecurityContext securityContext) {
            super(securityContext, null);
        }

        @Override
        public Object revert(Integer source) throws FrameworkException {
            return source;
        }

        @Override
        public Integer convert(Object source) throws FrameworkException {
            if (source == null) {
                return null;
            }
            if (source instanceof Number) {
                return ((Number)source).intValue();
            }
            if (source instanceof String && StringUtils.isNotBlank((CharSequence)((String)source))) {
                try {
                    return Double.valueOf(source.toString()).intValue();
                }
                catch (Throwable t) {
                    throw new FrameworkException(422, "Cannot parse input for property " + IntProperty.this.jsonName(), new NumberToken(IntProperty.this.declaringClass.getSimpleName(), IntProperty.this));
                }
            }
            return null;
        }
    }

    protected class DatabaseConverter
    extends PropertyConverter<Integer, Object> {
        public DatabaseConverter(SecurityContext securityContext) {
            super(securityContext, null);
        }

        @Override
        public Integer revert(Object source) throws FrameworkException {
            if (source instanceof Number) {
                return ((Number)source).intValue();
            }
            if (source instanceof String && StringUtils.isNotBlank((CharSequence)((String)source))) {
                try {
                    return Double.valueOf(source.toString()).intValue();
                }
                catch (Throwable t) {
                    throw new FrameworkException(422, "Cannot parse input for property " + IntProperty.this.jsonName(), new NumberToken(IntProperty.this.declaringClass.getSimpleName(), IntProperty.this));
                }
            }
            return null;
        }

        @Override
        public Object convert(Integer source) throws FrameworkException {
            return source;
        }
    }
}

