/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.structr.api.Predicate;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.property.AbstractReadOnlyProperty;
import org.structr.core.property.Property;

public class IntegerSumProperty
extends AbstractReadOnlyProperty<Integer> {
    private List<Property<Integer>> sumProperties = new LinkedList<Property<Integer>>();

    public IntegerSumProperty(String name, Property<Integer> ... properties) {
        super(name);
        this.sumProperties = Arrays.asList(properties);
    }

    @Override
    public Class relatedType() {
        return null;
    }

    @Override
    public Class valueType() {
        return Integer.class;
    }

    @Override
    public SortType getSortType() {
        return SortType.Integer;
    }

    @Override
    public Integer getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    @Override
    public Integer getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        int sum = 0;
        for (Property<Integer> prop : this.sumProperties) {
            Integer value = obj.getProperty(prop);
            if (value == null) continue;
            sum += value.intValue();
        }
        return sum;
    }

    @Override
    public boolean isCollection() {
        return false;
    }
}

